/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.casc;

import com.michelin.cio.hudson.plugins.rolestrategy.AuthorizationType;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@Restricted(value={NoExternalUse.class})
public class RoleDefinition {
    public static final Logger LOGGER = Logger.getLogger(RoleDefinition.class.getName());
    private transient Role role;
    @NonNull
    private final String name;
    @CheckForNull
    private final String description;
    @CheckForNull
    private final String pattern;
    private final Set<String> permissions;
    private SortedSet<RoleDefinitionEntry> entries = Collections.emptySortedSet();

    @DataBoundConstructor
    public RoleDefinition(String name, String description, String pattern, Collection<String> permissions) {
        this.name = name;
        this.description = description;
        this.pattern = pattern;
        this.permissions = permissions != null ? new HashSet<String>(permissions) : Collections.emptySet();
        this.role = this.getRole();
    }

    @DataBoundSetter
    @Deprecated
    public void setAssignments(Collection<String> assignments) {
        LOGGER.log(Level.WARNING, "Loading ambiguous role assignments via via configuration-as-code support");
        if (assignments != null) {
            TreeSet<RoleDefinitionEntry> entries = new TreeSet<RoleDefinitionEntry>();
            for (String assignment : assignments) {
                RoleDefinitionEntry rde = new RoleDefinitionEntry();
                rde.setEither(assignment);
                entries.add(rde);
            }
            this.entries = entries;
        }
    }

    @DataBoundSetter
    public void setEntries(Collection<RoleDefinitionEntry> entries) {
        this.entries = entries != null ? new TreeSet<RoleDefinitionEntry>(entries) : Collections.emptySortedSet();
    }

    public final Role getRole() {
        if (this.role == null) {
            Set<Permission> resolvedPermissions = PermissionHelper.fromStrings(this.permissions, false);
            Pattern p = Pattern.compile(this.pattern != null ? this.pattern : ".*");
            this.role = new Role(this.name, p, resolvedPermissions, this.description);
        }
        return this.role;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public Collection<String> getAssignments() {
        return null;
    }

    public SortedSet<RoleDefinitionEntry> getEntries() {
        return this.entries;
    }

    public static class RoleDefinitionEntry
    implements Comparable<RoleDefinitionEntry> {
        private AuthorizationType type;
        private String name;

        @DataBoundConstructor
        public RoleDefinitionEntry() {
        }

        private void setTypeIfUndefined(AuthorizationType type) {
            if (this.type != null) {
                throw new IllegalStateException("Cannot set two different types for '" + this.name + "'");
            }
            this.type = type;
        }

        @DataBoundSetter
        public void setUser(String name) {
            this.name = name;
            this.setTypeIfUndefined(AuthorizationType.USER);
        }

        @DataBoundSetter
        public void setGroup(String name) {
            this.name = name;
            this.setTypeIfUndefined(AuthorizationType.GROUP);
        }

        @DataBoundSetter
        public void setEither(String name) {
            this.name = name;
            this.setTypeIfUndefined(AuthorizationType.EITHER);
        }

        public String getUser() {
            return this.type == AuthorizationType.USER ? this.name : null;
        }

        public String getGroup() {
            return this.type == AuthorizationType.GROUP ? this.name : null;
        }

        public String getEither() {
            return this.type == AuthorizationType.EITHER ? this.name : null;
        }

        public PermissionEntry asPermissionEntry() {
            return new PermissionEntry(this.type, this.name);
        }

        public static RoleDefinitionEntry fromPermissionEntry(PermissionEntry entry) {
            RoleDefinitionEntry roleDefinitionEntry = new RoleDefinitionEntry();
            roleDefinitionEntry.type = entry.getType();
            roleDefinitionEntry.name = entry.getSid();
            return roleDefinitionEntry;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.name});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoleDefinitionEntry that = (RoleDefinitionEntry)o;
            return this.type == that.type && this.name.equals(that.name);
        }

        @Override
        public int compareTo(@NonNull RoleDefinitionEntry o) {
            int typeCompare = this.type.compareTo(o.type);
            if (typeCompare == 0) {
                return this.name.compareTo(o.name);
            }
            return typeCompare;
        }
    }
}

