/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.casc;

import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.rolestrategy.casc.RoleDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class GrantedRoles {
    private final List<RoleDefinition> global;
    private final List<RoleDefinition> items;
    private final List<RoleDefinition> agents;

    @DataBoundConstructor
    public GrantedRoles(List<RoleDefinition> global, List<RoleDefinition> items, List<RoleDefinition> agents) {
        this.global = global;
        this.items = items;
        this.agents = agents;
    }

    protected Map<String, RoleMap> toMap() {
        HashMap<String, RoleMap> grantedRoles = new HashMap<String, RoleMap>();
        if (this.global != null) {
            grantedRoles.put("globalRoles", this.retrieveRoleMap(this.global));
        }
        if (this.items != null) {
            grantedRoles.put("projectRoles", this.retrieveRoleMap(this.items));
        }
        if (this.agents != null) {
            grantedRoles.put("slaveRoles", this.retrieveRoleMap(this.agents));
        }
        return grantedRoles;
    }

    @NonNull
    private RoleMap retrieveRoleMap(List<RoleDefinition> definitions) {
        TreeMap<Role, Set<PermissionEntry>> resMap = new TreeMap<Role, Set<PermissionEntry>>();
        for (RoleDefinition definition : definitions) {
            resMap.put(definition.getRole(), definition.getEntries().stream().map(RoleDefinition.RoleDefinitionEntry::asPermissionEntry).collect(Collectors.toSet()));
        }
        return new RoleMap(resMap);
    }

    public List<RoleDefinition> getGlobal() {
        return this.global;
    }

    public List<RoleDefinition> getItems() {
        return this.items;
    }

    public List<RoleDefinition> getAgents() {
        return this.agents;
    }
}

