/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.AuthorizationType;
import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.ProjectNamingStrategy;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class RoleBasedProjectNamingStrategy
extends ProjectNamingStrategy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean forceExistingJobs;

    @DataBoundConstructor
    public RoleBasedProjectNamingStrategy(boolean forceExistingJobs) {
        this.forceExistingJobs = forceExistingJobs;
    }

    public void checkName(String name) throws Failure {
        StaplerRequest request = Stapler.getCurrentRequest();
        String parentName = "";
        if (request != null) {
            ItemGroup i = (ItemGroup)Stapler.getCurrentRequest().findAncestorObject(ItemGroup.class);
            parentName = i.getFullName();
        }
        this.checkName(parentName, name);
    }

    public void checkName(String parentName, String name) throws Failure {
        AuthorizationStrategy auth;
        if (StringUtils.isBlank((String)name)) {
            return;
        }
        Object fullName = name;
        if (StringUtils.isNotBlank((String)parentName)) {
            fullName = parentName + "/" + name;
        }
        if ((auth = Jenkins.get().getAuthorizationStrategy()) instanceof RoleBasedAuthorizationStrategy) {
            List<String> authorities;
            Authentication a = Jenkins.getAuthentication2();
            if (a == ACL.SYSTEM2) {
                return;
            }
            PermissionEntry principal = new PermissionEntry(AuthorizationType.USER, new PrincipalSid(a).getPrincipal());
            RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)auth;
            RoleMap global = rbas.getRoleMap(RoleType.Global);
            if (this.hasCreatePermission(global, principal, authorities = a.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList()), RoleType.Global)) {
                return;
            }
            RoleMap item = rbas.getRoleMap(RoleType.Project);
            if (!this.hasCreatePermission(item, principal, authorities, RoleType.Project)) {
                throw new Failure(Messages.RoleBasedProjectNamingStrategy_NoPermissions());
            }
            SortedMap<Role, Set<PermissionEntry>> roles = rbas.getGrantedRolesEntries(RoleType.Project);
            ArrayList<String> badList = new ArrayList<String>(roles.size());
            for (Map.Entry<Role, Set<PermissionEntry>> entry : roles.entrySet()) {
                Role key = entry.getKey();
                if (Macro.isMacro(key) || !key.hasPermission(Item.CREATE).booleanValue()) continue;
                Set<PermissionEntry> sids = entry.getValue();
                Pattern namePattern = key.getPattern();
                if (!StringUtils.isNotBlank((String)namePattern.toString())) continue;
                if (namePattern.matcher((CharSequence)fullName).matches()) {
                    if (!this.hasAnyPermission(principal, authorities, sids)) continue;
                    return;
                }
                badList.add(namePattern.toString());
            }
            String error = badList != null && !badList.isEmpty() ? Messages.RoleBasedProjectNamingStrategy_JobNameConventionNotApplyed(fullName, badList.toString()) : Messages.RoleBasedProjectNamingStrategy_NoPermissions();
            throw new Failure(error);
        }
    }

    private boolean hasAnyPermission(PermissionEntry principal, List<String> authorities, Set<PermissionEntry> sids) {
        PermissionEntry eitherUser = new PermissionEntry(AuthorizationType.EITHER, principal.getSid());
        if (sids.contains(principal) || sids.contains(eitherUser)) {
            return true;
        }
        for (String authority : authorities) {
            if (!sids.contains(new PermissionEntry(AuthorizationType.GROUP, authority)) && !sids.contains(new PermissionEntry(AuthorizationType.EITHER, authority))) continue;
            return true;
        }
        return false;
    }

    private boolean hasCreatePermission(RoleMap roleMap, PermissionEntry principal, List<String> authorities, RoleType roleType) {
        if (roleMap.hasPermission(principal, Item.CREATE, roleType, null)) {
            return true;
        }
        for (String group : authorities) {
            PermissionEntry groupEntry = new PermissionEntry(AuthorizationType.GROUP, group);
            if (!roleMap.hasPermission(groupEntry, Item.CREATE, roleType, null)) continue;
            return true;
        }
        return false;
    }

    public boolean isForceExistingJobs() {
        return this.forceExistingJobs;
    }

    @Extension
    public static final class DescriptorImpl
    extends ProjectNamingStrategy.ProjectNamingStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.RoleBasedAuthorizationStrategy_DisplayName();
        }
    }
}

