/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.AuthorizationType;
import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.PermissionEntry;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import com.michelin.cio.hudson.plugins.rolestrategy.ValidationUtil;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Functions;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.SecurityRealm;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rolestrategy.AmbiguousSidsAdminMonitor;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.GET;

public class RoleBasedAuthorizationStrategy
extends AuthorizationStrategy {
    private static Logger LOGGER = Logger.getLogger(RoleBasedAuthorizationStrategy.class.getName());
    public static final String GLOBAL = "globalRoles";
    public static final String PROJECT = "projectRoles";
    public static final String SLAVE = "slaveRoles";
    public static final String MACRO_ROLE = "roleMacros";
    public static final String MACRO_USER = "userMacros";
    private final RoleMap agentRoles;
    private final RoleMap globalRoles;
    private final RoleMap itemRoles;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public RoleBasedAuthorizationStrategy() {
        this.agentRoles = new RoleMap();
        this.globalRoles = new RoleMap();
        this.itemRoles = new RoleMap();
    }

    public RoleBasedAuthorizationStrategy(Map<String, RoleMap> grantedRoles) {
        RoleMap map = grantedRoles.get(SLAVE);
        this.agentRoles = map == null ? new RoleMap() : map;
        map = grantedRoles.get(GLOBAL);
        this.globalRoles = map == null ? new RoleMap() : map;
        map = grantedRoles.get(PROJECT);
        this.itemRoles = map == null ? new RoleMap() : map;
    }

    @NonNull
    public SidACL getRootACL() {
        return this.globalRoles.getACL(RoleType.Global, null);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public RoleMap getRoleMap(RoleType roleType) {
        switch (roleType) {
            case Global: {
                return this.globalRoles;
            }
            case Project: {
                return this.itemRoles;
            }
            case Slave: {
                return this.agentRoles;
            }
        }
        throw new IllegalArgumentException("Unknown RoleType: " + roleType);
    }

    @NonNull
    public ACL getACL(@NonNull Job<?, ?> project) {
        return this.getACL((AbstractItem)project);
    }

    @NonNull
    public ACL getACL(@NonNull AbstractItem project) {
        return this.itemRoles.newMatchingRoleMap(project.getFullName()).getACL(RoleType.Project, (AccessControlled)project).newInheritingACL(this.getRootACL());
    }

    @NonNull
    public ACL getACL(@NonNull Computer computer) {
        return this.agentRoles.newMatchingRoleMap(computer.getName()).getACL(RoleType.Slave, (AccessControlled)computer).newInheritingACL(this.getRootACL());
    }

    @NonNull
    public ACL getACL(@NonNull Node node) {
        return this.agentRoles.newMatchingRoleMap(node.getNodeName()).getACL(RoleType.Slave, (AccessControlled)node).newInheritingACL(this.getRootACL());
    }

    @NonNull
    public Collection<String> getGroups() {
        HashSet<String> sids = new HashSet<String>();
        sids.addAll(this.filterRoleSids(this.globalRoles));
        sids.addAll(this.filterRoleSids(this.itemRoles));
        sids.addAll(this.filterRoleSids(this.agentRoles));
        return sids;
    }

    private Set<String> filterRoleSids(RoleMap roleMap) {
        return roleMap.getSidEntries(false).stream().filter(entry -> entry.getType() != AuthorizationType.USER).map(PermissionEntry::getSid).collect(Collectors.toSet());
    }

    @Deprecated
    @Nullable
    public SortedMap<Role, Set<String>> getGrantedRoles(String type) {
        return this.getRoleMap(RoleType.fromString(type)).getGrantedRoles();
    }

    @Deprecated
    public SortedMap<Role, Set<String>> getGrantedRoles(@NonNull RoleType type) {
        return this.getRoleMap(type).getGrantedRoles();
    }

    public SortedMap<Role, Set<PermissionEntry>> getGrantedRolesEntries(@NonNull String type) {
        return this.getGrantedRolesEntries(RoleType.fromString(type));
    }

    public SortedMap<Role, Set<PermissionEntry>> getGrantedRolesEntries(@NonNull RoleType type) {
        return this.getRoleMap(type).getGrantedRolesEntries();
    }

    public Set<PermissionEntry> getSidEntries(String type) {
        return this.getRoleMap(RoleType.fromString(type)).getSidEntries();
    }

    @Deprecated
    @CheckForNull
    public Set<String> getSIDs(String type) {
        return this.getRoleMap(RoleType.fromString(type)).getSids();
    }

    @NonNull
    private Map<RoleType, RoleMap> getRoleMaps() {
        HashMap<RoleType, RoleMap> roleMaps = new HashMap<RoleType, RoleMap>();
        roleMaps.put(RoleType.Global, this.globalRoles);
        roleMaps.put(RoleType.Slave, this.agentRoles);
        roleMaps.put(RoleType.Project, this.itemRoles);
        return Collections.unmodifiableMap(roleMaps);
    }

    private void addRole(RoleType roleType, Role role) {
        this.getRoleMap(roleType).addRole(role);
    }

    private void assignRole(RoleType type, Role role, PermissionEntry sid) {
        RoleMap roleMap = this.getRoleMap(type);
        if (roleMap.hasRole(role)) {
            roleMap.assignRole(role, sid);
        }
    }

    private static void persistChanges() throws IOException {
        Jenkins j = RoleBasedAuthorizationStrategy.instance();
        j.save();
        AuthorizationStrategy as = j.getAuthorizationStrategy();
        if (as instanceof RoleBasedAuthorizationStrategy) {
            RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)as;
            rbas.validateConfig();
        }
    }

    private static Jenkins instance() {
        return Jenkins.get();
    }

    private static void checkAdminPerm() {
        RoleBasedAuthorizationStrategy.instance().checkPermission(Jenkins.ADMINISTER);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAddRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String permissionIds, @QueryParameter(required=true) String overwrite, @QueryParameter(required=false) String pattern) throws IOException {
        RoleMap roleMap;
        Role role2;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        boolean overwriteb = Boolean.parseBoolean(overwrite);
        String pttrn = ".*";
        if (!type.equals(GLOBAL) && pattern != null) {
            pttrn = pattern;
        }
        List<String> permissionList = Arrays.asList(permissionIds.split(","));
        Set<Permission> permissionSet = PermissionHelper.fromStrings(permissionList, true);
        Role role = new Role(roleName, pttrn, permissionSet);
        RoleType roleType = RoleType.fromString(type);
        if (overwriteb && (role2 = (roleMap = this.getRoleMap(roleType)).getRole(roleName)) != null) {
            roleMap.removeRole(role2);
        }
        this.addRole(roleType, role);
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doRemoveRoles(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleNames) throws IOException {
        String[] split;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        for (String roleName : split = roleNames.split(",")) {
            Role role = roleMap.getRole(roleName);
            if (role == null) continue;
            roleMap.removeRole(role);
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @Deprecated
    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleType roleType = RoleType.fromString(type);
        Role role = this.getRoleMap(roleType).getRole(roleName);
        if (role != null) {
            this.assignRole(roleType, role, new PermissionEntry(AuthorizationType.EITHER, sid));
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignUserRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String user) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleType roleType = RoleType.fromString(type);
        Role role = this.getRoleMap(roleType).getRole(roleName);
        if (role != null) {
            this.assignRole(roleType, role, new PermissionEntry(AuthorizationType.USER, user));
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignGroupRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String group) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleType roleType = RoleType.fromString(type);
        Role role = this.getRoleMap(roleType).getRole(roleName);
        if (role != null) {
            this.assignRole(roleType, role, new PermissionEntry(AuthorizationType.GROUP, group));
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteSid(@QueryParameter(required=true) String type, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        this.getRoleMap(RoleType.fromString(type)).deleteSids(new PermissionEntry(AuthorizationType.EITHER, sid));
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteUser(@QueryParameter(required=true) String type, @QueryParameter(required=true) String user) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        this.getRoleMap(RoleType.fromString(type)).deleteSids(new PermissionEntry(AuthorizationType.USER, user));
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteGroup(@QueryParameter(required=true) String type, @QueryParameter(required=true) String group) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        this.getRoleMap(RoleType.fromString(type)).deleteSids(new PermissionEntry(AuthorizationType.GROUP, group));
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            roleMap.deleteRoleSid(new PermissionEntry(AuthorizationType.EITHER, sid), role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignUserRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String user) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            roleMap.deleteRoleSid(new PermissionEntry(AuthorizationType.USER, user), role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignGroupRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String group) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            roleMap.deleteRoleSid(new PermissionEntry(AuthorizationType.GROUP, group), role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        JSONObject responseJson = new JSONObject();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            Set<Permission> permissions = role.getPermissions();
            HashMap<String, Boolean> permissionsMap = new HashMap<String, Boolean>();
            for (Permission permission : permissions) {
                permissionsMap.put(permission.getId(), permission.getEnabled());
            }
            responseJson.put("permissionIds", permissionsMap);
            if (!type.equals(GLOBAL)) {
                responseJson.put("pattern", (Object)role.getPattern().pattern());
            }
            SortedMap<Role, Set<PermissionEntry>> grantedRoleMap = roleMap.getGrantedRolesEntries();
            responseJson.put("sids", grantedRoleMap.get(role));
        }
        Stapler.getCurrentResponse().setContentType("application/json;charset=UTF-8");
        Writer writer = Stapler.getCurrentResponse().getCompressedWriter((HttpServletRequest)Stapler.getCurrentRequest());
        responseJson.write(writer);
        writer.close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetAllRoles(@QueryParameter(fixEmpty=true) String type) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        JSONObject responseJson = new JSONObject();
        RoleMap roleMap = this.getRoleMap(RoleType.Global);
        if (type != null) {
            roleMap = this.getRoleMap(RoleType.fromString(type));
        }
        for (Map.Entry<Role, Set<PermissionEntry>> grantedRole : roleMap.getGrantedRolesEntries().entrySet()) {
            responseJson.put(grantedRole.getKey().getName(), grantedRole.getValue());
        }
        Stapler.getCurrentResponse().setContentType("application/json;charset=UTF-8");
        Writer writer = Stapler.getCurrentResponse().getCompressedWriter((HttpServletRequest)Stapler.getCurrentRequest());
        responseJson.write(writer);
        writer.close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetMatchingJobs(@QueryParameter(required=true) String pattern, @QueryParameter int maxJobs) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        ArrayList<String> matchingItems = new ArrayList<String>();
        int itemCount = RoleMap.getMatchingItemNames(matchingItems, Pattern.compile(pattern), maxJobs);
        JSONObject responseJson = new JSONObject();
        responseJson.put("matchingJobs", matchingItems);
        responseJson.put("itemCount", (Object)itemCount);
        StaplerResponse response = Stapler.getCurrentResponse();
        response.setContentType("application/json;charset=UTF-8");
        Writer writer = response.getCompressedWriter((HttpServletRequest)Stapler.getCurrentRequest());
        responseJson.write(writer);
        writer.close();
    }

    @GET
    @Restricted(value={NoExternalUse.class})
    public void doGetMatchingAgents(@QueryParameter(required=true) String pattern, @QueryParameter int maxAgents) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        ArrayList<String> matchingAgents = new ArrayList<String>();
        int agentCount = RoleMap.getMatchingAgentNames(matchingAgents, Pattern.compile(pattern), maxAgents);
        JSONObject responseJson = new JSONObject();
        responseJson.put("matchingAgents", matchingAgents);
        responseJson.put("agentCount", (Object)agentCount);
        StaplerResponse response = Stapler.getCurrentResponse();
        response.setContentType("application/json;charset=UTF-8");
        Writer writer = response.getCompressedWriter((HttpServletRequest)Stapler.getCurrentRequest());
        responseJson.write(writer);
        writer.close();
    }

    @Restricted(value={NoExternalUse.class})
    public void validateConfig() {
        ArrayList<PermissionEntry> sids = new ArrayList<PermissionEntry>();
        sids.addAll(this.getSidEntries(GLOBAL));
        sids.addAll(this.getSidEntries(SLAVE));
        sids.addAll(this.getSidEntries(PROJECT));
        AmbiguousSidsAdminMonitor.get().updateEntries(sids);
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_LOADED)
    public static void init() {
        Jenkins j = RoleBasedAuthorizationStrategy.instance();
        AuthorizationStrategy as = j.getAuthorizationStrategy();
        if (as instanceof RoleBasedAuthorizationStrategy) {
            RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)as;
            rbas.validateConfig();
        }
    }

    @CheckForNull
    public static RoleBasedAuthorizationStrategy getInstance() {
        AuthorizationStrategy authStrategy;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        AuthorizationStrategy authorizationStrategy = authStrategy = jenkins != null ? jenkins.getAuthorizationStrategy() : null;
        if (authStrategy instanceof RoleBasedAuthorizationStrategy) {
            return (RoleBasedAuthorizationStrategy)authStrategy;
        }
        return null;
    }

    @Deprecated
    public static boolean isCreateAllowed() {
        return true;
    }

    public static final class DescriptorImpl
    extends Descriptor<AuthorizationStrategy> {
        @NonNull
        public String getDisplayName() {
            return Messages.RoleBasedAuthorizationStrategy_DisplayName();
        }

        @RequirePOST
        public FormValidation doCheckForWhitespace(@QueryParameter String value) {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            if (value == null || value.trim().equals(value)) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)Messages.RoleBasedProjectNamingStrategy_WhiteSpaceWillBeTrimmed());
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doRolesSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy strategy = this.newInstance(req, json);
            RoleBasedAuthorizationStrategy.instance().setAuthorizationStrategy(strategy);
            RoleBasedAuthorizationStrategy.persistChanges();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (json.has(RoleBasedAuthorizationStrategy.GLOBAL) && json.has(RoleBasedAuthorizationStrategy.PROJECT) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
                Map<RoleType, RoleMap> maps = strategy.getRoleMaps();
                for (Map.Entry<RoleType, RoleMap> map : maps.entrySet()) {
                    RoleMap roleMap = map.getValue();
                    roleMap.clearSids();
                    JSONObject roles = json.getJSONObject(map.getKey().getStringType());
                    if (roles.isNullObject()) continue;
                    for (Map.Entry r : roles.getJSONObject("data").entrySet()) {
                        String sid = (String)r.getKey();
                        if (sid == null || sid.equals("")) continue;
                        PermissionEntry pe = PermissionEntry.fromString(sid);
                        for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                            Role role;
                            if (!((Boolean)e.getValue()).booleanValue() || (role = roleMap.getRole((String)e.getKey())) == null) continue;
                            roleMap.assignRole(role, pe);
                        }
                    }
                }
                RoleBasedAuthorizationStrategy.persistChanges();
            }
        }

        public AuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) {
            RoleBasedAuthorizationStrategy strategy;
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (formData.has(RoleBasedAuthorizationStrategy.GLOBAL) && formData.has(RoleBasedAuthorizationStrategy.PROJECT) && formData.has(RoleBasedAuthorizationStrategy.SLAVE) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = new RoleBasedAuthorizationStrategy();
                JSONObject globalRoles = formData.getJSONObject(RoleBasedAuthorizationStrategy.GLOBAL);
                for (Map.Entry r : globalRoles.getJSONObject("data").entrySet()) {
                    Set<PermissionEntry> sids;
                    String roleName = (String)r.getKey();
                    HashSet<Permission> permissions = new HashSet<Permission>();
                    for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                        if (!((Boolean)e.getValue()).booleanValue()) continue;
                        Permission p = Permission.fromId((String)((String)e.getKey()));
                        permissions.add(p);
                    }
                    Role role = new Role(roleName, permissions);
                    strategy.addRole(RoleType.Global, role);
                    RoleMap roleMap = ((RoleBasedAuthorizationStrategy)oldStrategy).getRoleMap(RoleType.Global);
                    if (roleMap == null || (sids = roleMap.getSidEntriesForRole(roleName)) == null) continue;
                    for (PermissionEntry sid : sids) {
                        strategy.assignRole(RoleType.Global, role, sid);
                    }
                }
                this.readRoles(formData, RoleType.Project, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
                this.readRoles(formData, RoleType.Slave, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
            } else if (oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
            } else {
                strategy = new RoleBasedAuthorizationStrategy();
                Role adminRole = this.createAdminRole();
                strategy.addRole(RoleType.Global, adminRole);
                strategy.assignRole(RoleType.Global, adminRole, new PermissionEntry(AuthorizationType.USER, this.getCurrentUser()));
            }
            return strategy;
        }

        private void readRoles(JSONObject formData, RoleType roleType, RoleBasedAuthorizationStrategy targetStrategy, RoleBasedAuthorizationStrategy oldStrategy) {
            String roleTypeAsString = roleType.getStringType();
            if (!formData.has(roleTypeAsString)) {
                assert (false) : "Unexistent Role type " + roleTypeAsString;
                return;
            }
            JSONObject projectRoles = formData.getJSONObject(roleTypeAsString);
            if (!projectRoles.containsKey((Object)"data")) {
                assert (false) : "No data at role description";
                return;
            }
            for (Map.Entry r : projectRoles.getJSONObject("data").entrySet()) {
                Set<PermissionEntry> sids;
                String roleName = (String)r.getKey();
                HashSet<Permission> permissions = new HashSet<Permission>();
                String pattern = ((JSONObject)r.getValue()).getString("pattern");
                if (pattern != null) {
                    ((JSONObject)r.getValue()).remove("pattern");
                } else {
                    pattern = ".*";
                }
                for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    permissions.add(p);
                }
                Role role = new Role(roleName, pattern, permissions);
                targetStrategy.addRole(roleType, role);
                RoleMap roleMap = oldStrategy.getRoleMap(roleType);
                if (roleMap == null || (sids = roleMap.getSidEntriesForRole(roleName)) == null) continue;
                for (PermissionEntry sid : sids) {
                    targetStrategy.assignRole(roleType, role, sid);
                }
            }
        }

        private Role createAdminRole() {
            HashSet<Permission> permissions = new HashSet<Permission>();
            permissions.add(Jenkins.ADMINISTER);
            return new Role("admin", permissions);
        }

        private String getCurrentUser() {
            PrincipalSid currentUser = new PrincipalSid(Jenkins.getAuthentication2());
            return currentUser.getPrincipal();
        }

        @Nullable
        public List<PermissionGroup> getGroups(@NonNull String type) {
            ArrayList<PermissionGroup> groups = new ArrayList<PermissionGroup>();
            ArrayList filterGroups = new ArrayList(PermissionGroup.getAll());
            switch (type) {
                case "globalRoles": {
                    break;
                }
                case "projectRoles": {
                    filterGroups.remove(PermissionGroup.get(Hudson.class));
                    filterGroups.remove(PermissionGroup.get(Computer.class));
                    break;
                }
                case "slaveRoles": {
                    filterGroups.remove(PermissionGroup.get(Permission.class));
                    filterGroups.remove(PermissionGroup.get(Hudson.class));
                    filterGroups.remove(PermissionGroup.get(View.class));
                    filterGroups.remove(PermissionGroup.get(Item.class));
                    filterGroups.remove(PermissionGroup.get(SCM.class));
                    filterGroups.remove(PermissionGroup.get(Run.class));
                    break;
                }
                default: {
                    filterGroups = new ArrayList();
                }
            }
            block10: for (PermissionGroup group : filterGroups) {
                if (group == PermissionGroup.get(Permission.class)) continue;
                for (Permission p : group.getPermissions()) {
                    if (!p.getEnabled()) continue;
                    groups.add(group);
                    continue block10;
                }
            }
            return groups;
        }

        @Restricted(value={NoExternalUse.class})
        public boolean showPermission(String type, Permission p) {
            switch (type) {
                case "globalRoles": {
                    if (PermissionHelper.isDangerous(p)) {
                        return false;
                    }
                    return p.getEnabled();
                }
                case "projectRoles": {
                    return p.getEnabled();
                }
                case "slaveRoles": {
                    return p != Computer.CREATE && p.getEnabled();
                }
            }
            return false;
        }

        @Restricted(value={DoNotUse.class})
        public String impliedByList(Permission p) {
            ArrayList<Permission> impliedBys = new ArrayList<Permission>();
            while (p.impliedBy != null) {
                p = p.impliedBy;
                impliedBys.add(p);
            }
            return StringUtils.join((Collection)impliedBys.stream().map(Permission::getId).collect(Collectors.toList()), (String)" ");
        }

        @Restricted(value={DoNotUse.class})
        public PermissionEntry entryFor(String type, String sid) {
            if (type == null) {
                return null;
            }
            return new PermissionEntry(AuthorizationType.valueOf(type), sid);
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckPattern(@QueryParameter String value) {
            try {
                Pattern.compile(value);
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)pse.getMessage());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckName(@QueryParameter String value) {
            AuthorizationType type;
            String unbracketedValue = value.substring(1, value.length() - 1);
            int splitIndex = unbracketedValue.indexOf(58);
            if (splitIndex < 0) {
                return FormValidation.error((String)("No type prefix: " + unbracketedValue));
            }
            String typeString = unbracketedValue.substring(0, splitIndex);
            try {
                type = AuthorizationType.valueOf(typeString);
            }
            catch (Exception ex) {
                return FormValidation.error((String)("Invalid type prefix: " + unbracketedValue));
            }
            String sid = unbracketedValue.substring(splitIndex + 1);
            String escapedSid = Functions.escape((String)sid);
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok((String)escapedSid);
            }
            SecurityRealm sr = Jenkins.get().getSecurityRealm();
            if (sid.equals("authenticated") && type == AuthorizationType.EITHER) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(type, escapedSid, "Internal group found; but permissions would also be granted to a user of this name", true));
            }
            if (sid.equals("anonymous") && type == AuthorizationType.EITHER) {
                return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatUserGroupValidationResponse(type, escapedSid, "Internal user found; but permissions would also be granted to a group of this name", true));
            }
            try {
                switch (type) {
                    case GROUP: {
                        FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, false);
                        if (groupValidation != null) {
                            return groupValidation;
                        }
                        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatNonExistentUserGroupValidationResponse(type, escapedSid, "Group not found"));
                    }
                    case USER: {
                        FormValidation userValidation = ValidationUtil.validateUser(sid, sr, false);
                        if (userValidation != null) {
                            return userValidation;
                        }
                        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatNonExistentUserGroupValidationResponse(type, escapedSid, "User not found"));
                    }
                    case EITHER: {
                        FormValidation userValidation = ValidationUtil.validateUser(sid, sr, true);
                        if (userValidation != null) {
                            return userValidation;
                        }
                        FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, true);
                        if (groupValidation != null) {
                            return groupValidation;
                        }
                        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ValidationUtil.formatNonExistentUserGroupValidationResponse(type, escapedSid, "User or group not found", true));
                    }
                }
                return FormValidation.error((String)("Unexpected type: " + type));
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)escapedSid);
            }
        }

        @Restricted(value={DoNotUse.class})
        public boolean hasAmbiguousEntries(SortedMap<Role, Set<PermissionEntry>> grantedRoles) {
            return grantedRoles.entrySet().stream().anyMatch(entry -> ((Set)entry.getValue()).stream().anyMatch(pe -> pe.getType() == AuthorizationType.EITHER));
        }
    }

    public static class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == RoleBasedAuthorizationStrategy.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)((Object)source);
            Map<RoleType, RoleMap> maps = strategy.getRoleMaps();
            for (Map.Entry<RoleType, RoleMap> map : maps.entrySet()) {
                RoleMap roleMap = map.getValue();
                writer.startNode("roleMap");
                writer.addAttribute("type", map.getKey().getStringType());
                for (Map.Entry<Role, Set<PermissionEntry>> grantedRole : roleMap.getGrantedRolesEntries().entrySet()) {
                    Role role = grantedRole.getKey();
                    if (role == null) continue;
                    writer.startNode("role");
                    writer.addAttribute("name", role.getName());
                    writer.addAttribute("pattern", role.getPattern().pattern());
                    writer.startNode("permissions");
                    for (Permission permission : role.getPermissions()) {
                        writer.startNode("permission");
                        writer.setValue(permission.getId());
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.startNode("assignedSIDs");
                    for (PermissionEntry entry : grantedRole.getValue()) {
                        writer.startNode("sid");
                        writer.addAttribute("type", entry.getType().toString());
                        writer.setValue(entry.getSid());
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HashMap<String, RoleMap> roleMaps = new HashMap<String, RoleMap>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals("roleMap")) {
                    String type = reader.getAttribute("type");
                    RoleMap map = new RoleMap();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        String name = reader.getAttribute("name");
                        String pattern = reader.getAttribute("pattern");
                        HashSet<Permission> permissions = new HashSet<Permission>();
                        String next = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
                        if (next != null && next.equals("permissions")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                Permission p = PermissionHelper.resolvePermissionFromString(reader.getValue());
                                if (p != null) {
                                    permissions.add(p);
                                }
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        Role role = new Role(name, pattern, permissions);
                        map.addRole(role);
                        next = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
                        if (next != null && next.equals("assignedSIDs")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                String entryTypeValue = reader.getAttribute("type");
                                AuthorizationType authType = AuthorizationType.EITHER;
                                String sid = reader.getValue();
                                if (entryTypeValue != null) {
                                    try {
                                        authType = AuthorizationType.valueOf(entryTypeValue);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        LOGGER.log(Level.WARNING, "Unknown AuthorizationType {0} for SID {1} in Role {2}/{3}", new Object[]{entryTypeValue, sid, type, name});
                                        throw ex;
                                    }
                                }
                                PermissionEntry pe = new PermissionEntry(authType, sid);
                                map.assignRole(role, pe);
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        reader.moveUp();
                    }
                    roleMaps.put(type, map);
                }
                reader.moveUp();
            }
            return new RoleBasedAuthorizationStrategy(roleMaps);
        }

        protected RoleBasedAuthorizationStrategy create() {
            return new RoleBasedAuthorizationStrategy();
        }
    }
}

