/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.casc;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class RoleDefinition {
    private transient Role role;
    @NonNull
    private final String name;
    @CheckForNull
    private final String description;
    @CheckForNull
    private final String pattern;
    private final Set<String> permissions;
    private final Set<String> assignments;

    @DataBoundConstructor
    public RoleDefinition(@NonNull String name, @CheckForNull String description, @CheckForNull String pattern, Collection<String> permissions, Collection<String> assignments) {
        this.name = name;
        this.description = description;
        this.pattern = pattern;
        this.permissions = permissions != null ? new HashSet<String>(permissions) : Collections.emptySet();
        this.assignments = assignments != null ? new HashSet<String>(assignments) : Collections.emptySet();
        this.role = this.getRole();
    }

    public final Role getRole() {
        if (this.role == null) {
            Set<Permission> resolvedPermissions = PermissionHelper.fromStrings(this.permissions, false);
            Pattern p = Pattern.compile(this.pattern != null ? this.pattern : ".*");
            this.role = new Role(this.name, p, resolvedPermissions, this.description);
        }
        return this.role;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @CheckForNull
    public String getPattern() {
        return this.pattern;
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    public Set<String> getAssignments() {
        return Collections.unmodifiableSet(this.assignments);
    }
}

