/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.rolestrategy.macros;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ListView;
import hudson.model.View;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.rolestrategy.Settings;
import org.springframework.security.core.Authentication;

@Extension(optional=true)
public class ContainedInViewMacro
extends RoleMacroExtension {
    private final Cache<Macro, Map<View, Set<String>>> cache = Caffeine.newBuilder().maximumSize((long)Settings.VIEW_CACHE_MAX_SIZE).expireAfterWrite((long)Settings.VIEW_CACHE_EXPIRATION_TIME_SEC, TimeUnit.SECONDS).weakKeys().build();
    private final Cache<View, Set<String>> viewCache = Caffeine.newBuilder().maximumSize((long)Settings.VIEW_CACHE_MAX_SIZE).expireAfterWrite((long)Settings.VIEW_CACHE_EXPIRATION_TIME_SEC, TimeUnit.SECONDS).weakKeys().build();

    @Override
    public String getName() {
        return "ContainedInView";
    }

    @Override
    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="Old code, should be fixed later")
    public boolean IsApplicable(RoleType roleType) {
        return roleType == RoleType.Project;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="we know that the cache has no null entries")
    public boolean hasPermission(String sid, Permission p, RoleType type, AccessControlled accessControlledItem, Macro macro) {
        if (accessControlledItem instanceof Item) {
            Item item = (Item)accessControlledItem;
            Map items = (Map)this.cache.get((Object)macro, this::getItemsForMacro);
            for (Map.Entry entry : items.entrySet()) {
                if (!((Set)entry.getValue()).contains(item.getFullName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Access items that are added to a ListView. Specify the views as parameter to the macro, e.g. <code>@ContainedInView(view1, view2)</code>. Prepend the folder name if the view is in a folder, e.g. <code>@ContainedInView(folder/view1)</code> (To access views inside a folder, access to the folder itself is required).<br/>When enabling the <dfn>Recurse in subfolders</dfn> option, make sure to also check the folders themselves for which you add items.<br/>NestedView plugin is not supported currently as this allows to create ambiguous names for views.";
    }

    private Map<View, Set<String>> getItemsForMacro(Macro macro) {
        HashMap<View, Set<String>> viewList = new HashMap<View, Set<String>>();
        for (String viewName : macro.getParameters()) {
            View view = this.getViewFromFullName(viewName);
            if (view == null) continue;
            viewList.put(view, (Set)this.viewCache.get((Object)view, this::getItemsForView));
        }
        return viewList;
    }

    private Set<String> getItemsForView(View view) {
        TreeSet<String> items = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        try (ACLContext c = ACL.as2((Authentication)ACL.SYSTEM2);){
            items.addAll(view.getItems().stream().map(Item::getFullName).collect(Collectors.toSet()));
        }
        return items;
    }

    @CheckForNull
    private View getViewFromFullName(String viewName) {
        block10: {
            Jenkins jenkins = Jenkins.get();
            try (ACLContext c = ACL.as2((Authentication)ACL.SYSTEM2);){
                int index = viewName.lastIndexOf("/");
                if (index > 0) {
                    String folderFullName = viewName.substring(0, index);
                    String viewBaseName = viewName.substring(index + 1);
                    AbstractFolder folder = (AbstractFolder)jenkins.getItemByFullName(folderFullName, AbstractFolder.class);
                    if (folder == null) break block10;
                    for (View view : folder.getViews()) {
                        if (!(view instanceof ListView) || !view.getViewName().equals(viewBaseName) || view.getOwner() != folder) continue;
                        View view2 = view;
                        return view2;
                    }
                    break block10;
                }
                View view = jenkins.getView(viewName);
                if (view instanceof ListView && view.getOwner() == Jenkins.get()) {
                    View view3 = view;
                    return view3;
                }
            }
        }
        return null;
    }
}

