/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.ManagementLink;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.util.FormApply;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class RoleStrategyConfig
extends ManagementLink {
    public String getIconFileName() {
        if (Jenkins.get().getAuthorizationStrategy() instanceof RoleBasedAuthorizationStrategy) {
            return "icon-secure";
        }
        return null;
    }

    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    public String getUrlName() {
        return "role-strategy";
    }

    @NonNull
    public String getCategoryName() {
        return "SECURITY";
    }

    public String getDisplayName() {
        return Messages.RoleBasedAuthorizationStrategy_ManageAndAssign();
    }

    public String getAssignRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Assign();
    }

    public String getManageRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Manage();
    }

    public String getDescription() {
        return Messages.RoleBasedAuthorizationStrategy_Description();
    }

    @CheckForNull
    public AuthorizationStrategy getStrategy() {
        AuthorizationStrategy strategy = Jenkins.get().getAuthorizationStrategy();
        if (strategy instanceof RoleBasedAuthorizationStrategy) {
            return strategy;
        }
        return null;
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doRolesSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doRolesSubmit(req, rsp);
        FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doAssignSubmit(req, rsp);
        FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
    }

    public ExtensionList<RoleMacroExtension> getRoleMacroExtensions() {
        return RoleMacroExtension.all();
    }

    public final RoleType getGlobalRoleType() {
        return RoleType.Global;
    }

    public final RoleType getProjectRoleType() {
        return RoleType.Project;
    }

    public final RoleType getSlaveRoleType() {
        return RoleType.Slave;
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-pencil icon-sm", "plugin/role-strategy/images/pencil.svg", "width: 16px; height: 16px;"));
        IconSet.icons.addIcon(new Icon("icon-pencil icon-md", "plugin/role-strategy/images/pencil.svg", "width: 24px; height: 24px;"));
        IconSet.icons.addIcon(new Icon("icon-pencil icon-ld", "plugin/role-strategy/images/pencil.svg", "width: 32px; height: 32px;"));
        IconSet.icons.addIcon(new Icon("icon-pencil icon-xlg", "plugin/role-strategy/images/pencil.svg", "width: 48px; height: 48px;"));
    }
}

