/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.casc;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.casc.Attribute;
import io.jenkins.plugins.casc.BaseConfigurator;
import io.jenkins.plugins.casc.ConfigurationContext;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Mapping;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.rolestrategy.casc.GrantedRoles;
import org.jenkinsci.plugins.rolestrategy.casc.RoleDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(optional=true, ordinal=2.0)
@Restricted(value={NoExternalUse.class})
public class RoleBasedAuthorizationStrategyConfigurator
extends BaseConfigurator<RoleBasedAuthorizationStrategy> {
    @NonNull
    public String getName() {
        return "roleStrategy";
    }

    public Class<RoleBasedAuthorizationStrategy> getTarget() {
        return RoleBasedAuthorizationStrategy.class;
    }

    @NonNull
    public Class getImplementedAPI() {
        return GrantedRoles.class;
    }

    protected RoleBasedAuthorizationStrategy instance(Mapping map, ConfigurationContext context) throws ConfiguratorException {
        Configurator c = context.lookupOrFail(GrantedRoles.class);
        GrantedRoles roles = (GrantedRoles)c.configure((CNode)map.remove((Object)"roles"), context);
        return new RoleBasedAuthorizationStrategy(roles.toMap());
    }

    @NonNull
    public Set<Attribute<RoleBasedAuthorizationStrategy, ?>> describe() {
        return Collections.singleton(new Attribute("roles", GrantedRoles.class).getter(target -> {
            List<RoleDefinition> globalRoles = this.getRoleDefinitions(target.getGrantedRoles(RoleType.Global));
            List<RoleDefinition> agentRoles = this.getRoleDefinitions(target.getGrantedRoles(RoleType.Slave));
            List<RoleDefinition> projectRoles = this.getRoleDefinitions(target.getGrantedRoles(RoleType.Project));
            return new GrantedRoles(globalRoles, projectRoles, agentRoles);
        }));
    }

    @CheckForNull
    public CNode describe(RoleBasedAuthorizationStrategy instance, ConfigurationContext context) throws Exception {
        return this.compare((Object)instance, (Object)new RoleBasedAuthorizationStrategy(Collections.emptyMap()), context);
    }

    private List<RoleDefinition> getRoleDefinitions(@CheckForNull SortedMap<Role, Set<String>> roleMap) {
        if (roleMap == null) {
            return Collections.emptyList();
        }
        return roleMap.entrySet().stream().map(this.getRoleDefinition()).collect(Collectors.toList());
    }

    private Function<Map.Entry<Role, Set<String>>, RoleDefinition> getRoleDefinition() {
        return roleSetEntry -> {
            Role role = (Role)roleSetEntry.getKey();
            List<String> permissions = role.getPermissions().stream().map(permission -> permission.group.getId() + "/" + permission.name).collect(Collectors.toList());
            return new RoleDefinition(role.getName(), role.getDescription(), role.getPattern().pattern(), permissions, (Collection)roleSetEntry.getValue());
        };
    }
}

