/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.userdetails.UserDetails;
import org.jenkinsci.plugins.rolestrategy.Settings;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.dao.DataAccessException;

public class RoleMap {
    private final SortedMap<Role, Set<String>> grantedRoles;
    private static final Logger LOGGER = Logger.getLogger(RoleMap.class.getName());
    private static final ConcurrentMap<Permission, Set<Permission>> implyingPermissionCache = new ConcurrentHashMap<Permission, Set<Permission>>();
    private final Cache<String, UserDetails> cache = Caffeine.newBuilder().maximumSize((long)Settings.USER_DETAILS_CACHE_MAX_SIZE).expireAfterWrite((long)Settings.USER_DETAILS_CACHE_EXPIRATION_TIME_SEC, TimeUnit.SECONDS).build();
    private final Cache<String, RoleMap> matchingRoleMapCache = Caffeine.newBuilder().maximumSize(2048L).expireAfterWrite(1L, TimeUnit.HOURS).build();

    RoleMap() {
        this.grantedRoles = new ConcurrentSkipListMap<Role, Set<String>>();
    }

    @DataBoundConstructor
    public RoleMap(@NonNull SortedMap<Role, Set<String>> grantedRoles) {
        this();
        for (Map.Entry<Role, Set<String>> entry : grantedRoles.entrySet()) {
            this.grantedRoles.put(entry.getKey(), new HashSet(entry.getValue()));
        }
    }

    private boolean hasPermission(final String sid, final Permission permission, final RoleType roleType, final AccessControlled controlledItem) {
        final Set<Permission> permissions = RoleMap.getImplyingPermissions(permission);
        final boolean[] hasPermission = new boolean[]{false};
        new RoleWalker(){

            @Override
            public void perform(Role current) {
                if (current.hasAnyPermission(permissions).booleanValue()) {
                    if (((Set)RoleMap.this.grantedRoles.get(current)).contains(sid)) {
                        if (Macro.isMacro(current)) {
                            RoleMacroExtension macroExtension;
                            Macro macro = RoleMacroExtension.getMacro(current.getName());
                            if (macro != null && (macroExtension = RoleMacroExtension.getMacroExtension(macro.getName())).IsApplicable(roleType) && macroExtension.hasPermission(sid, permission, roleType, controlledItem, macro)) {
                                hasPermission[0] = true;
                                this.abort();
                            }
                        } else {
                            hasPermission[0] = true;
                            this.abort();
                        }
                    } else if (Settings.TREAT_USER_AUTHORITIES_AS_ROLES) {
                        try {
                            UserDetails userDetails = (UserDetails)RoleMap.this.cache.getIfPresent((Object)sid);
                            if (userDetails == null) {
                                userDetails = Jenkins.get().getSecurityRealm().loadUserByUsername(sid);
                                RoleMap.this.cache.put((Object)sid, (Object)userDetails);
                            }
                            for (GrantedAuthority grantedAuthority : userDetails.getAuthorities()) {
                                if (!grantedAuthority.getAuthority().equals(current.getName())) continue;
                                hasPermission[0] = true;
                                this.abort();
                                return;
                            }
                        }
                        catch (BadCredentialsException e) {
                            LOGGER.log(Level.FINE, "Bad credentials", e);
                        }
                        catch (DataAccessException e) {
                            LOGGER.log(Level.FINE, "failed to access the data", e);
                        }
                        catch (RuntimeException ex) {
                            LOGGER.log(Level.WARNING, "Unhandled exception during user authorities processing", ex);
                        }
                    }
                }
            }
        };
        return hasPermission[0];
    }

    private static Set<Permission> getImplyingPermissions(Permission p) {
        Set implyingPermissions = (Set)implyingPermissionCache.get(p);
        if (implyingPermissions != null) {
            return implyingPermissions;
        }
        return RoleMap.cacheImplyingPermissions(p);
    }

    private static Set<Permission> cacheImplyingPermissions(Permission permission) {
        Set<Permission> implyingPermissions;
        if (PermissionHelper.isDangerous(permission)) {
            implyingPermissions = RoleMap.getImplyingPermissions(Jenkins.ADMINISTER);
        } else {
            implyingPermissions = new HashSet<Permission>();
            Permission p = permission;
            while (p != null) {
                implyingPermissions.add(p);
                p = p.impliedBy;
            }
        }
        implyingPermissionCache.put(permission, implyingPermissions);
        return implyingPermissions;
    }

    public boolean hasRole(@NonNull Role role) {
        return this.grantedRoles.containsKey(role);
    }

    public SidACL getACL(RoleType roleType, AccessControlled controlledItem) {
        return new AclImpl(roleType, controlledItem);
    }

    public void addRole(Role role) {
        if (this.getRole(role.getName()) == null) {
            this.grantedRoles.put(role, new CopyOnWriteArraySet());
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void assignRole(Role role, String sid) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).add(sid);
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void unAssignRole(Role role, String sid) {
        Set sids = (Set)this.grantedRoles.get(role);
        if (sids != null) {
            sids.remove(sid);
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void clearSidsForRole(Role role) {
        if (this.hasRole(role)) {
            ((Set)this.grantedRoles.get(role)).clear();
            this.matchingRoleMapCache.invalidateAll();
        }
    }

    public void deleteSids(String sid) {
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            Set<String> sids = entry.getValue();
            sids.remove(sid);
        }
        this.matchingRoleMapCache.invalidateAll();
    }

    public void deleteRoleSid(String sid, String rolename) {
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            Role role = entry.getKey();
            if (!role.getName().equals(rolename)) continue;
            this.unAssignRole(role, sid);
            break;
        }
    }

    public void clearSids() {
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            Role role = entry.getKey();
            this.clearSidsForRole(role);
        }
    }

    @CheckForNull
    public Role getRole(String name) {
        for (Role role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public void removeRole(Role role) {
        this.grantedRoles.remove(role);
        this.matchingRoleMapCache.invalidateAll();
    }

    public SortedMap<Role, Set<String>> getGrantedRoles() {
        return Collections.unmodifiableSortedMap(this.grantedRoles);
    }

    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this.grantedRoles.keySet());
    }

    public SortedSet<String> getSids() {
        return this.getSids(false);
    }

    public SortedSet<String> getSids(Boolean includeAnonymous) {
        TreeSet sids = new TreeSet();
        for (Map.Entry<Role, Set<String>> entry : this.grantedRoles.entrySet()) {
            sids.addAll(entry.getValue());
        }
        if (!includeAnonymous.booleanValue()) {
            sids.remove("anonymous");
        }
        return Collections.unmodifiableSortedSet(sids);
    }

    @CheckForNull
    public Set<String> getSidsForRole(String roleName) {
        Role role = this.getRole(roleName);
        if (role != null) {
            return Collections.unmodifiableSet((Set)this.grantedRoles.get(role));
        }
        return null;
    }

    public RoleMap newMatchingRoleMap(String itemNamePrefix) {
        return (RoleMap)this.matchingRoleMapCache.get((Object)itemNamePrefix, this::createMatchingRoleMap);
    }

    private RoleMap createMatchingRoleMap(final String itemNamePrefix) {
        final TreeMap<Role, Set<String>> roleMap = new TreeMap<Role, Set<String>>();
        new RoleWalker(){

            @Override
            public void perform(Role current) {
                Matcher m = current.getPattern().matcher(itemNamePrefix);
                if (m.matches()) {
                    roleMap.put(current, (Set)RoleMap.this.grantedRoles.get(current));
                }
            }
        };
        return new RoleMap(roleMap);
    }

    public static List<String> getMatchingJobNames(Pattern pattern, int maxJobs) {
        ArrayList<String> matchingJobNames = new ArrayList<String>();
        for (Item i2 : Jenkins.get().allItems(Item.class, i -> pattern.matcher(i.getFullName()).matches())) {
            if (matchingJobNames.size() >= maxJobs) break;
            matchingJobNames.add(i2.getFullName());
        }
        return matchingJobNames;
    }

    private static boolean shouldCheckParentPermissions() {
        String propertyName = RoleMap.class.getName() + ".checkParentPermissions";
        String value = System.getProperty(propertyName);
        if (value == null) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }

    static {
        Permission.getAll().forEach(RoleMap::cacheImplyingPermissions);
    }

    private abstract class RoleWalker {
        boolean shouldAbort = false;

        RoleWalker() {
            this.walk();
        }

        public void abort() {
            this.shouldAbort = true;
        }

        public void walk() {
            Set<Role> roles = RoleMap.this.getRoles();
            for (Role current : roles) {
                this.perform(current);
                if (!this.shouldAbort) continue;
                break;
            }
        }

        public abstract void perform(Role var1);
    }

    private final class AclImpl
    extends SidACL {
        AccessControlled item;
        RoleType roleType;

        public AclImpl(RoleType roleType, AccessControlled item) {
            this.item = item;
            this.roleType = roleType;
        }

        @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="As declared in Jenkins API")
        @CheckForNull
        protected Boolean hasPermission(Sid sid, Permission permission) {
            if (RoleMap.this.hasPermission(this.toString(sid), permission, this.roleType, this.item)) {
                ItemGroup parent;
                if (this.item instanceof Item && (parent = ((Item)this.item).getParent()) instanceof Item && (Item.DISCOVER.equals((Object)permission) || Item.READ.equals((Object)permission)) && RoleMap.shouldCheckParentPermissions()) {
                    Permission requiredPermissionOnParent;
                    Permission permission2 = requiredPermissionOnParent = permission == Item.DISCOVER ? Item.DISCOVER : Item.READ;
                    if (!((Item)parent).hasPermission(requiredPermissionOnParent)) {
                        return null;
                    }
                }
                return true;
            }
            return null;
        }
    }
}

