/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.permissions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.PluginManager;
import hudson.security.Permission;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PermissionHelper {
    @Restricted(value={NoExternalUse.class})
    public static final Set<Permission> DANGEROUS_PERMISSIONS = Collections.unmodifiableSet(new HashSet<Permission>(Arrays.asList(Jenkins.RUN_SCRIPTS, PluginManager.CONFIGURE_UPDATECENTER, PluginManager.UPLOAD_PLUGINS)));

    private PermissionHelper() {
    }

    @NonNull
    public static Set<Permission> fromStrings(@CheckForNull Collection<String> permissionIds) throws SecurityException {
        if (permissionIds == null) {
            return Collections.emptySet();
        }
        HashSet<Permission> res = new HashSet<Permission>(permissionIds.size());
        for (String permission : permissionIds) {
            Permission p = Permission.fromId((String)permission);
            if (p == null) continue;
            if (PermissionHelper.isDangerous(p)) {
                throw new SecurityException("Rejected dangerous permission: " + permission);
            }
            res.add(p);
        }
        return res;
    }

    public static boolean isDangerous(@NonNull Permission p) {
        return DANGEROUS_PERMISSIONS.contains(p);
    }
}

