/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.rolestrategy.macros;

import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Job;
import hudson.security.AccessControlled;
import hudson.security.Permission;

@Extension
public class BuildableJobMacro
extends RoleMacroExtension {
    @Override
    public String getName() {
        return "BuildableJob";
    }

    @Override
    @SuppressFBWarnings(value={"NM_METHOD_NAMING_CONVENTION"}, justification="Old code, should be fixed later")
    public boolean IsApplicable(RoleType roleType) {
        return roleType == RoleType.Project;
    }

    @Override
    public boolean hasPermission(String sid, Permission p, RoleType type, AccessControlled item, Macro macro) {
        if (Job.class.isAssignableFrom(item.getClass())) {
            Job job = (Job)item;
            return job.isBuildable();
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Filters out unbuildable jobs";
    }
}

