/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.google.common.collect.ImmutableMap;
import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import com.synopsys.arc.jenkins.plugins.rolestrategy.UserMacroExtension;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.jenkinsci.plugins.rolestrategy.permissions.PermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RoleBasedAuthorizationStrategy
extends AuthorizationStrategy {
    public static final String GLOBAL = "globalRoles";
    public static final String PROJECT = "projectRoles";
    public static final String SLAVE = "slaveRoles";
    public static final String MACRO_ROLE = "roleMacros";
    public static final String MACRO_USER = "userMacros";
    private final RoleMap agentRoles;
    private final RoleMap globalRoles;
    private final RoleMap itemRoles;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public RoleBasedAuthorizationStrategy() {
        this.agentRoles = new RoleMap();
        this.globalRoles = new RoleMap();
        this.itemRoles = new RoleMap();
    }

    public RoleBasedAuthorizationStrategy(Map<String, RoleMap> grantedRoles) {
        RoleMap map = grantedRoles.get(SLAVE);
        this.agentRoles = map == null ? new RoleMap() : map;
        map = grantedRoles.get(GLOBAL);
        this.globalRoles = map == null ? new RoleMap() : map;
        map = grantedRoles.get(PROJECT);
        this.itemRoles = map == null ? new RoleMap() : map;
    }

    @Nonnull
    public SidACL getRootACL() {
        return this.globalRoles.getACL(RoleType.Global, null);
    }

    @Nonnull
    private RoleMap getRoleMap(RoleType roleType) {
        switch (roleType) {
            case Global: {
                return this.globalRoles;
            }
            case Project: {
                return this.itemRoles;
            }
            case Slave: {
                return this.agentRoles;
            }
        }
        throw new IllegalArgumentException("Unknown RoleType: " + (Object)((Object)roleType));
    }

    @Nonnull
    public ACL getACL(@Nonnull Job<?, ?> project) {
        return this.getACL((AbstractItem)project);
    }

    @Nonnull
    public ACL getACL(@Nonnull AbstractItem project) {
        return this.itemRoles.newMatchingRoleMap(project.getFullName()).getACL(RoleType.Project, (AccessControlled)project).newInheritingACL(this.getRootACL());
    }

    @Nonnull
    public ACL getACL(@Nonnull Computer computer) {
        return this.agentRoles.newMatchingRoleMap(computer.getName()).getACL(RoleType.Slave, (AccessControlled)computer).newInheritingACL(this.getRootACL());
    }

    @Nonnull
    public Collection<String> getGroups() {
        HashSet<String> sids = new HashSet<String>();
        sids.addAll(this.globalRoles.getSids(true));
        sids.addAll(this.itemRoles.getSids(true));
        sids.addAll(this.agentRoles.getSids(true));
        return sids;
    }

    @Nullable
    @Deprecated
    public SortedMap<Role, Set<String>> getGrantedRoles(String type) {
        return this.getGrantedRoles(RoleType.fromString(type));
    }

    public SortedMap<Role, Set<String>> getGrantedRoles(@Nonnull RoleType type) {
        return this.getRoleMap(type).getGrantedRoles();
    }

    @CheckForNull
    public Set<String> getSIDs(String type) {
        return this.getRoleMap(RoleType.fromString(type)).getSids();
    }

    @Nonnull
    private Map<RoleType, RoleMap> getRoleMaps() {
        return ImmutableMap.of((Object)((Object)RoleType.Global), (Object)this.globalRoles, (Object)((Object)RoleType.Slave), (Object)this.agentRoles, (Object)((Object)RoleType.Project), (Object)this.itemRoles);
    }

    private void addRole(RoleType roleType, Role role) {
        this.getRoleMap(roleType).addRole(role);
    }

    private void assignRole(RoleType type, Role role, String sid) {
        RoleMap roleMap = this.getRoleMap(type);
        if (roleMap.hasRole(role)) {
            roleMap.assignRole(role, sid);
        }
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAddRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String permissionIds, @QueryParameter(required=true) String overwrite, @QueryParameter(required=false) String pattern) throws IOException {
        RoleMap roleMap;
        Role role2;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        boolean overwriteb = Boolean.parseBoolean(overwrite);
        String pttrn = ".*";
        if (!type.equals(GLOBAL) && pattern != null) {
            pttrn = pattern;
        }
        ArrayList<String> permissionList = new ArrayList<String>(Arrays.asList(permissionIds.split(",")));
        HashSet<Permission> permissionSet = new HashSet<Permission>();
        for (String p : permissionList) {
            Permission temp = Permission.fromId((String)p);
            if (temp == null) {
                throw new IOException("Cannot find permission for id=" + p + ", role name=" + roleName + " role type=" + type);
            }
            permissionSet.add(temp);
        }
        Role role = new Role(roleName, pttrn, permissionSet);
        RoleType roleType = RoleType.fromString(type);
        if (overwriteb && (role2 = (roleMap = this.getRoleMap(roleType)).getRole(roleName)) != null) {
            roleMap.removeRole(role2);
        }
        this.addRole(roleType, role);
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @Restricted(value={NoExternalUse.class})
    public void doGetRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        JSONObject responseJson = new JSONObject();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            Set<Permission> permissions = role.getPermissions();
            HashMap<String, Boolean> permissionsMap = new HashMap<String, Boolean>();
            for (Permission permission : permissions) {
                permissionsMap.put(permission.getId(), permission.getEnabled());
            }
            responseJson.put("permissionIds", permissionsMap);
            if (!type.equals(GLOBAL)) {
                responseJson.put("pattern", (Object)role.getPattern().pattern());
            }
            SortedMap<Role, Set<String>> grantedRoleMap = roleMap.getGrantedRoles();
            responseJson.put("sids", grantedRoleMap.get(role));
        }
        Stapler.getCurrentResponse().setContentType("application/json;charset=UTF-8");
        Writer writer = Stapler.getCurrentResponse().getCompressedWriter((HttpServletRequest)Stapler.getCurrentRequest());
        responseJson.write(writer);
        writer.close();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doRemoveRoles(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleNames) throws IOException {
        String[] split;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        for (String aSplit : split = roleNames.split(",")) {
            Role role = roleMap.getRole(aSplit);
            if (role == null) continue;
            roleMap.removeRole(role);
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleType roleType = RoleType.fromString(type);
        Role role = this.getRoleMap(roleType).getRole(roleName);
        if (role != null) {
            this.assignRole(roleType, role, sid);
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    private static void persistChanges() throws IOException {
        RoleBasedAuthorizationStrategy.instance().save();
    }

    private static Jenkins instance() {
        return Jenkins.getInstance();
    }

    private static void checkAdminPerm() {
        RoleBasedAuthorizationStrategy.instance().checkPermission(Jenkins.ADMINISTER);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteSid(@QueryParameter(required=true) String type, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        this.getRoleMap(RoleType.fromString(type)).deleteSids(sid);
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.getRoleMap(RoleType.fromString(type));
        Role role = roleMap.getRole(roleName);
        if (role != null) {
            roleMap.deleteRoleSid(sid, role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @Restricted(value={NoExternalUse.class})
    public void doGetAllRoles(@QueryParameter(fixEmpty=true) String type) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        JSONObject responseJson = new JSONObject();
        RoleMap roleMap = this.getRoleMap(RoleType.Global);
        if (type != null) {
            roleMap = this.getRoleMap(RoleType.fromString(type));
        }
        for (Map.Entry<Role, Set<String>> grantedRole : roleMap.getGrantedRoles().entrySet()) {
            responseJson.put(grantedRole.getKey().getName(), grantedRole.getValue());
        }
        Stapler.getCurrentResponse().setContentType("application/json;charset=UTF-8");
        Writer writer = Stapler.getCurrentResponse().getCompressedWriter((HttpServletRequest)Stapler.getCurrentRequest());
        responseJson.write(writer);
        writer.close();
    }

    @Restricted(value={NoExternalUse.class})
    public void doGetMatchingJobs(@QueryParameter(required=true) String pattern, @QueryParameter int maxJobs) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        List<String> matchingJobs = RoleMap.getMatchingJobNames(Pattern.compile(pattern), maxJobs);
        JSONObject responseJson = new JSONObject();
        responseJson.put("matchingJobs", matchingJobs);
        StaplerResponse response = Stapler.getCurrentResponse();
        response.addHeader("Content-Type", "application/json");
        Writer writer = response.getCompressedWriter((HttpServletRequest)Stapler.getCurrentRequest());
        responseJson.write(writer);
        writer.close();
    }

    @CheckForNull
    public static RoleBasedAuthorizationStrategy getInstance() {
        AuthorizationStrategy authStrategy;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        AuthorizationStrategy authorizationStrategy = authStrategy = jenkins != null ? jenkins.getAuthorizationStrategy() : null;
        if (authStrategy instanceof RoleBasedAuthorizationStrategy) {
            return (RoleBasedAuthorizationStrategy)authStrategy;
        }
        return null;
    }

    void renewMacroRoles() {
        for (UserMacroExtension userExt : UserMacroExtension.all()) {
            if (!userExt.IsApplicable(RoleType.Global)) continue;
            this.getRoleMap(RoleType.Global).getSids().contains(userExt.getName());
        }
    }

    @Deprecated
    public static boolean isCreateAllowed() {
        return true;
    }

    public static final class DescriptorImpl
    extends GlobalMatrixAuthorizationStrategy.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return Messages.RoleBasedAuthorizationStrategy_DisplayName();
        }

        public FormValidation doCheckForWhitespace(@QueryParameter String value) {
            if (value == null || value.trim().equals(value)) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)Messages.RoleBasedProjectNamingStrategy_WhiteSpaceWillBeTrimmed());
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doRolesSubmit(StaplerRequest req, StaplerResponse rsp) throws UnsupportedEncodingException, ServletException, Descriptor.FormException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy strategy = this.newInstance(req, json);
            RoleBasedAuthorizationStrategy.instance().setAuthorizationStrategy(strategy);
            RoleBasedAuthorizationStrategy.persistChanges();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws UnsupportedEncodingException, ServletException, Descriptor.FormException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (json.has(RoleBasedAuthorizationStrategy.GLOBAL) && json.has(RoleBasedAuthorizationStrategy.PROJECT) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
                Map maps = strategy.getRoleMaps();
                for (Map.Entry map : maps.entrySet()) {
                    RoleMap roleMap = (RoleMap)map.getValue();
                    roleMap.clearSids();
                    JSONObject roles = json.getJSONObject(((RoleType)((Object)map.getKey())).getStringType());
                    if (roles.isNullObject()) continue;
                    for (Map.Entry r : roles.getJSONObject("data").entrySet()) {
                        String sid = (String)r.getKey();
                        for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                            Role role;
                            if (!((Boolean)e.getValue()).booleanValue() || (role = roleMap.getRole((String)e.getKey())) == null || sid == null || sid.equals("")) continue;
                            roleMap.assignRole(role, sid);
                        }
                    }
                }
                RoleBasedAuthorizationStrategy.persistChanges();
            }
        }

        public AuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            RoleBasedAuthorizationStrategy strategy;
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (formData.has(RoleBasedAuthorizationStrategy.GLOBAL) && formData.has(RoleBasedAuthorizationStrategy.PROJECT) && formData.has(RoleBasedAuthorizationStrategy.SLAVE) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = new RoleBasedAuthorizationStrategy();
                JSONObject globalRoles = formData.getJSONObject(RoleBasedAuthorizationStrategy.GLOBAL);
                for (Map.Entry r : globalRoles.getJSONObject("data").entrySet()) {
                    Set<String> sids;
                    String roleName = (String)r.getKey();
                    HashSet<Permission> permissions = new HashSet<Permission>();
                    for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                        if (!((Boolean)e.getValue()).booleanValue()) continue;
                        Permission p = Permission.fromId((String)((String)e.getKey()));
                        permissions.add(p);
                    }
                    Role role = new Role(roleName, permissions);
                    strategy.addRole(RoleType.Global, role);
                    RoleMap roleMap = ((RoleBasedAuthorizationStrategy)oldStrategy).getRoleMap(RoleType.Global);
                    if (roleMap == null || (sids = roleMap.getSidsForRole(roleName)) == null) continue;
                    for (String sid : sids) {
                        strategy.assignRole(RoleType.Global, role, sid);
                    }
                }
                this.readRoles(formData, RoleType.Project, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
                this.readRoles(formData, RoleType.Slave, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
            } else if (oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
            } else {
                strategy = new RoleBasedAuthorizationStrategy();
                Role adminRole = this.createAdminRole();
                strategy.addRole(RoleType.Global, adminRole);
                strategy.assignRole(RoleType.Global, adminRole, this.getCurrentUser());
            }
            strategy.renewMacroRoles();
            return strategy;
        }

        private void readRoles(JSONObject formData, RoleType roleType, RoleBasedAuthorizationStrategy targetStrategy, RoleBasedAuthorizationStrategy oldStrategy) {
            String roleTypeAsString = roleType.getStringType();
            if (!formData.has(roleTypeAsString)) {
                assert (false) : "Unexistent Role type " + roleTypeAsString;
                return;
            }
            JSONObject projectRoles = formData.getJSONObject(roleTypeAsString);
            if (!projectRoles.containsKey((Object)"data")) {
                assert (false) : "No data at role description";
                return;
            }
            for (Map.Entry r : projectRoles.getJSONObject("data").entrySet()) {
                Set<String> sids;
                String roleName = (String)r.getKey();
                HashSet<Permission> permissions = new HashSet<Permission>();
                String pattern = ((JSONObject)r.getValue()).getString("pattern");
                if (pattern != null) {
                    ((JSONObject)r.getValue()).remove("pattern");
                } else {
                    pattern = ".*";
                }
                for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    permissions.add(p);
                }
                Role role = new Role(roleName, pattern, permissions);
                targetStrategy.addRole(roleType, role);
                RoleMap roleMap = oldStrategy.getRoleMap(roleType);
                if (roleMap == null || (sids = roleMap.getSidsForRole(roleName)) == null) continue;
                for (String sid : sids) {
                    targetStrategy.assignRole(roleType, role, sid);
                }
            }
        }

        private Role createAdminRole() {
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (PermissionGroup group : this.getGroups(RoleBasedAuthorizationStrategy.GLOBAL)) {
                for (Permission permission : group) {
                    permissions.add(permission);
                }
            }
            Role role = new Role("admin", permissions);
            return role;
        }

        private String getCurrentUser() {
            PrincipalSid currentUser = new PrincipalSid(Hudson.getAuthentication());
            return currentUser.getPrincipal();
        }

        @Nullable
        public List<PermissionGroup> getGroups(@Nonnull String type) {
            ArrayList<Object> groups;
            if (type.equals(RoleBasedAuthorizationStrategy.GLOBAL)) {
                groups = new ArrayList<PermissionGroup>(PermissionGroup.getAll());
                groups.remove(PermissionGroup.get(Permission.class));
            } else if (type.equals(RoleBasedAuthorizationStrategy.PROJECT)) {
                groups = new ArrayList(PermissionGroup.getAll());
                groups.remove(PermissionGroup.get(Permission.class));
                groups.remove(PermissionGroup.get(Hudson.class));
                groups.remove(PermissionGroup.get(Computer.class));
                groups.remove(PermissionGroup.get(View.class));
            } else if (type.equals(RoleBasedAuthorizationStrategy.SLAVE)) {
                groups = new ArrayList(PermissionGroup.getAll());
                groups.remove(PermissionGroup.get(Permission.class));
                groups.remove(PermissionGroup.get(Hudson.class));
                groups.remove(PermissionGroup.get(View.class));
                groups.remove(PermissionGroup.get(Item.class));
                groups.remove(PermissionGroup.get(SCM.class));
                groups.remove(PermissionGroup.get(Run.class));
            } else {
                groups = null;
            }
            return groups;
        }

        @Restricted(value={NoExternalUse.class})
        public boolean showPermission(String type, Permission p) {
            switch (type) {
                case "globalRoles": {
                    if (PermissionHelper.isDangerous(p)) {
                        return false;
                    }
                    return p.getEnabled();
                }
                case "projectRoles": {
                    return p == Item.CREATE && p.getEnabled() || p != Item.CREATE && p.getEnabled();
                }
                case "slaveRoles": {
                    return p != Computer.CREATE && p.getEnabled();
                }
            }
            return false;
        }
    }

    public static class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == RoleBasedAuthorizationStrategy.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)((Object)source);
            Map maps = strategy.getRoleMaps();
            for (Map.Entry map : maps.entrySet()) {
                RoleMap roleMap = (RoleMap)map.getValue();
                writer.startNode("roleMap");
                writer.addAttribute("type", ((RoleType)((Object)map.getKey())).getStringType());
                for (Map.Entry<Role, Set<String>> grantedRole : roleMap.getGrantedRoles().entrySet()) {
                    Role role = grantedRole.getKey();
                    if (role == null) continue;
                    writer.startNode("role");
                    writer.addAttribute("name", role.getName());
                    writer.addAttribute("pattern", role.getPattern().pattern());
                    writer.startNode("permissions");
                    for (Permission permission : role.getPermissions()) {
                        writer.startNode("permission");
                        writer.setValue(permission.getId());
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.startNode("assignedSIDs");
                    for (String sid : grantedRole.getValue()) {
                        writer.startNode("sid");
                        writer.setValue(sid);
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            HashMap<String, RoleMap> roleMaps = new HashMap<String, RoleMap>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals("roleMap")) {
                    String type = reader.getAttribute("type");
                    RoleMap map = new RoleMap();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        String name = reader.getAttribute("name");
                        String pattern = reader.getAttribute("pattern");
                        HashSet<Permission> permissions = new HashSet<Permission>();
                        String next = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
                        if (next != null && next.equals("permissions")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                Permission p = Permission.fromId((String)reader.getValue());
                                if (p != null) {
                                    permissions.add(p);
                                }
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        Role role = new Role(name, pattern, permissions);
                        map.addRole(role);
                        next = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
                        if (next != null && next.equals("assignedSIDs")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                map.assignRole(role, reader.getValue());
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        reader.moveUp();
                    }
                    roleMaps.put(type, map);
                }
                reader.moveUp();
            }
            return new RoleBasedAuthorizationStrategy(roleMaps);
        }

        protected RoleBasedAuthorizationStrategy create() {
            return new RoleBasedAuthorizationStrategy();
        }
    }
}

