/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy.permissions;

import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import hudson.PluginManager;
import hudson.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.rolestrategy.permissions.DangerousPermissionHandlingMode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DangerousPermissionHelper {
    @Restricted(value={NoExternalUse.class})
    public static final Set<Permission> DANGEROUS_PERMISSIONS = Collections.unmodifiableSet(new HashSet<Permission>(Arrays.asList(Jenkins.RUN_SCRIPTS, PluginManager.CONFIGURE_UPDATECENTER, PluginManager.UPLOAD_PLUGINS)));

    private DangerousPermissionHelper() {
    }

    public static boolean isDangerous(@Nonnull Permission p) {
        if (DangerousPermissionHandlingMode.CURRENT == DangerousPermissionHandlingMode.ENABLED) {
            return false;
        }
        return DANGEROUS_PERMISSIONS.contains(p);
    }

    public static boolean hasPotentiallyDangerousPermissions(@Nonnull Role r) {
        return r.hasPermission(Jenkins.ADMINISTER) == false && r.hasAnyPermission(DANGEROUS_PERMISSIONS) != false;
    }

    @CheckForNull
    public static String reportDangerousPermissions(@Nonnull RoleBasedAuthorizationStrategy strategy) {
        SortedMap<Role, Set<String>> grantedRoles = strategy.getGrantedRoles("globalRoles");
        return grantedRoles != null ? DangerousPermissionHelper.reportDangerousPermissions(grantedRoles.keySet()) : null;
    }

    @CheckForNull
    public static String reportDangerousPermissions(@Nonnull Iterable<Role> roles) {
        ArrayList<String> dangerousRoleNames = new ArrayList<String>();
        for (Role role : roles) {
            if (!DangerousPermissionHelper.hasPotentiallyDangerousPermissions(role)) continue;
            dangerousRoleNames.add(role.getName());
        }
        if (dangerousRoleNames.isEmpty()) {
            return null;
        }
        StringBuilder report = new StringBuilder("Dangerous roles found: [");
        report.append(StringUtils.join(dangerousRoleNames, (String)","));
        report.append("] do not declare Jenkins.ADMINISTER and contain one of the following permissions: ");
        report.append(StringUtils.join(DANGEROUS_PERMISSIONS, (String)","));
        return report.toString();
    }

    @CheckForNull
    public static boolean hasDangerousPermissions(@Nonnull RoleBasedAuthorizationStrategy strategy) {
        SortedMap<Role, Set<String>> grantedRoles = strategy.getGrantedRoles("globalRoles");
        if (grantedRoles == null) {
            return false;
        }
        return DangerousPermissionHelper.hasDangerousPermissions(grantedRoles.keySet());
    }

    @CheckForNull
    public static boolean hasDangerousPermissions(@Nonnull Iterable<Role> roles) {
        for (Role role : roles) {
            if (!DangerousPermissionHelper.hasPotentiallyDangerousPermissions(role)) continue;
            return true;
        }
        return false;
    }
}

