/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleMap;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import com.synopsys.arc.jenkins.plugins.rolestrategy.UserMacroExtension;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.SidACL;
import hudson.util.VersionNumber;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.jenkinsci.plugins.rolestrategy.permissions.DangerousPermissionHandlingMode;
import org.jenkinsci.plugins.rolestrategy.permissions.DangerousPermissionHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RoleBasedAuthorizationStrategy
extends AuthorizationStrategy {
    public static final String GLOBAL = "globalRoles";
    public static final String PROJECT = "projectRoles";
    public static final String SLAVE = "slaveRoles";
    public static final String MACRO_ROLE = "roleMacros";
    public static final String MACRO_USER = "userMacros";
    private static final Logger LOGGER = Logger.getLogger(RoleBasedAuthorizationStrategy.class.getName());
    private final Map<String, RoleMap> grantedRoles = new HashMap<String, RoleMap>();
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public SidACL getRootACL() {
        RoleMap root = this.getRoleMap(GLOBAL);
        return root.getACL(RoleType.Global, null);
    }

    private ACL getACL(String roleMapName, String itemName, RoleType roleType, AccessControlled item) {
        RoleMap roleMap = this.grantedRoles.get(roleMapName);
        SidACL acl = roleMap == null ? this.getRootACL() : roleMap.newMatchingRoleMap(itemName).getACL(roleType, item).newInheritingACL(this.getRootACL());
        return acl;
    }

    public ACL getACL(Job<?, ?> project) {
        return this.getACL((AbstractItem)project);
    }

    public ACL getACL(AbstractItem project) {
        return this.getACL(PROJECT, project.getFullName(), RoleType.Project, (AccessControlled)project);
    }

    public ACL getACL(Computer computer) {
        return this.getACL(SLAVE, computer.getName(), RoleType.Slave, (AccessControlled)computer);
    }

    public Collection<String> getGroups() {
        HashSet<String> sids = new HashSet<String>();
        for (Map.Entry<String, RoleMap> entry : this.grantedRoles.entrySet()) {
            RoleMap roleMap = entry.getValue();
            sids.addAll(roleMap.getSids(true));
        }
        return sids;
    }

    @Nullable
    public SortedMap<Role, Set<String>> getGrantedRoles(String type) {
        RoleMap roleMap = this.getRoleMap(type);
        if (roleMap != null) {
            return roleMap.getGrantedRoles();
        }
        return null;
    }

    @CheckForNull
    public Set<String> getSIDs(String type) {
        RoleMap roleMap = this.getRoleMap(type);
        if (roleMap != null) {
            return roleMap.getSids();
        }
        return null;
    }

    private RoleMap getRoleMap(String type) {
        RoleMap map;
        if (this.grantedRoles.containsKey(type)) {
            map = this.grantedRoles.get(type);
        } else {
            map = new RoleMap();
            this.grantedRoles.put(type, map);
        }
        return map;
    }

    private Map<String, RoleMap> getRoleMaps() {
        return this.grantedRoles;
    }

    private void addRole(String type, Role role) {
        RoleMap roleMap = this.grantedRoles.get(type);
        if (roleMap != null) {
            roleMap.addRole(role);
        } else {
            roleMap = new RoleMap();
            roleMap.addRole(role);
            this.grantedRoles.put(type, roleMap);
        }
    }

    private void assignRole(String type, Role role, String sid) {
        RoleMap roleMap = this.grantedRoles.get(type);
        if (roleMap != null && roleMap.hasRole(role)) {
            roleMap.assignRole(role, sid);
        }
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAddRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String permissionIds, @QueryParameter(required=true) String overwrite, @QueryParameter(required=false) String pattern) throws IOException {
        Role role2;
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        boolean overwriteb = Boolean.parseBoolean(overwrite);
        String pttrn = ".*";
        if (!type.equals(GLOBAL) && pattern != null) {
            pttrn = pattern;
        }
        ArrayList<String> permissionList = new ArrayList<String>();
        permissionList.addAll(Arrays.asList(permissionIds.split(",")));
        HashSet<Permission> permissionSet = new HashSet<Permission>();
        for (String p : permissionList) {
            permissionSet.add(Permission.fromId((String)p));
        }
        Role role = new Role(roleName, pttrn, permissionSet);
        if (overwriteb && (role2 = this.grantedRoles.get(type).getRole(roleName)) != null) {
            this.grantedRoles.get(type).removeRole(role2);
        }
        this.addRole(type, role);
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doRemoveRoles(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleNames) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.grantedRoles.get(type);
        if (roleMap != null) {
            String[] split;
            for (String aSplit : split = roleNames.split(",")) {
                Role role = roleMap.getRole(aSplit);
                if (role == null) continue;
                roleMap.removeRole(role);
            }
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doAssignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.grantedRoles.get(type);
        if (roleMap != null) {
            Role role = roleMap.getRole(roleName);
            if (role != null) {
                this.assignRole(type, role, sid);
            }
            RoleBasedAuthorizationStrategy.persistChanges();
        }
    }

    private static void persistChanges() throws IOException {
        RoleBasedAuthorizationStrategy.instance().save();
    }

    private static Jenkins instance() {
        return Jenkins.getInstance();
    }

    private static void checkAdminPerm() {
        RoleBasedAuthorizationStrategy.instance().checkPermission(Jenkins.ADMINISTER);
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doDeleteSid(@QueryParameter(required=true) String type, @QueryParameter(required=true) String sid) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.grantedRoles.get(type);
        if (roleMap != null) {
            roleMap.deleteSids(sid);
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doUnassignRole(@QueryParameter(required=true) String type, @QueryParameter(required=true) String roleName, @QueryParameter(required=true) String sid) throws IOException {
        Role role;
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        RoleMap roleMap = this.grantedRoles.get(type);
        if (roleMap != null && (role = roleMap.getRole(roleName)) != null) {
            roleMap.deleteRoleSid(sid, role.getName());
        }
        RoleBasedAuthorizationStrategy.persistChanges();
    }

    @Restricted(value={NoExternalUse.class})
    public void doGetAllRoles(StaplerRequest req, StaplerResponse rsp) throws IOException {
        RoleBasedAuthorizationStrategy.checkAdminPerm();
        req.setCharacterEncoding("UTF-8");
        ServletOutputStream os = rsp.getOutputStream();
        JSONObject json = new JSONObject();
        RoleMap roleMap = this.grantedRoles.get(GLOBAL);
        for (Map.Entry<Role, Set<String>> grantedRole : roleMap.getGrantedRoles().entrySet()) {
            json.put(grantedRole.getKey().getName(), grantedRole.getValue());
        }
        os.write(json.toString().getBytes("UTF-8"));
    }

    @CheckForNull
    public static RoleBasedAuthorizationStrategy getInstance() {
        AuthorizationStrategy authStrategy;
        Jenkins jenkins = Jenkins.getInstance();
        AuthorizationStrategy authorizationStrategy = authStrategy = jenkins != null ? jenkins.getAuthorizationStrategy() : null;
        if (authStrategy instanceof RoleBasedAuthorizationStrategy) {
            return (RoleBasedAuthorizationStrategy)authStrategy;
        }
        return null;
    }

    void renewMacroRoles() {
        for (UserMacroExtension userExt : UserMacroExtension.all()) {
            if (!userExt.IsApplicable(RoleType.Global)) continue;
            this.getRoleMap(GLOBAL).getSids().contains(userExt.getName());
        }
    }

    public static boolean isCreateAllowed() {
        return Jenkins.getVersion().isNewerThan(new VersionNumber("1.566"));
    }

    public static final class DescriptorImpl
    extends GlobalMatrixAuthorizationStrategy.DescriptorImpl {
        public String getDisplayName() {
            return Messages.RoleBasedAuthorizationStrategy_DisplayName();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doRolesSubmit(StaplerRequest req, StaplerResponse rsp) throws UnsupportedEncodingException, ServletException, Descriptor.FormException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy strategy = this.newInstance(req, json);
            RoleBasedAuthorizationStrategy.instance().setAuthorizationStrategy(strategy);
            RoleBasedAuthorizationStrategy.persistChanges();
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws UnsupportedEncodingException, ServletException, Descriptor.FormException, IOException {
            RoleBasedAuthorizationStrategy.checkAdminPerm();
            req.setCharacterEncoding("UTF-8");
            JSONObject json = req.getSubmittedForm();
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (json.has(RoleBasedAuthorizationStrategy.GLOBAL) && json.has(RoleBasedAuthorizationStrategy.PROJECT) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
                Map maps = strategy.getRoleMaps();
                for (Map.Entry map : maps.entrySet()) {
                    RoleMap roleMap = (RoleMap)map.getValue();
                    roleMap.clearSids();
                    JSONObject roles = json.getJSONObject((String)map.getKey());
                    if (roles.isNullObject()) continue;
                    for (Map.Entry r : roles.getJSONObject("data").entrySet()) {
                        String sid = (String)r.getKey();
                        for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                            Role role;
                            if (!((Boolean)e.getValue()).booleanValue() || (role = roleMap.getRole((String)e.getKey())) == null || sid == null || sid.equals("")) continue;
                            roleMap.assignRole(role, sid);
                        }
                    }
                }
                RoleBasedAuthorizationStrategy.persistChanges();
            }
        }

        public AuthorizationStrategy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            RoleBasedAuthorizationStrategy strategy;
            AuthorizationStrategy oldStrategy = RoleBasedAuthorizationStrategy.instance().getAuthorizationStrategy();
            if (formData.has(RoleBasedAuthorizationStrategy.GLOBAL) && formData.has(RoleBasedAuthorizationStrategy.PROJECT) && formData.has(RoleBasedAuthorizationStrategy.SLAVE) && oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = new RoleBasedAuthorizationStrategy();
                JSONObject globalRoles = formData.getJSONObject(RoleBasedAuthorizationStrategy.GLOBAL);
                for (Map.Entry r : globalRoles.getJSONObject("data").entrySet()) {
                    Set<String> sids;
                    String roleName = (String)r.getKey();
                    HashSet<Permission> permissions = new HashSet<Permission>();
                    for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                        if (!((Boolean)e.getValue()).booleanValue()) continue;
                        Permission p = Permission.fromId((String)((String)e.getKey()));
                        permissions.add(p);
                    }
                    Role role = new Role(roleName, permissions);
                    strategy.addRole(RoleBasedAuthorizationStrategy.GLOBAL, role);
                    RoleMap roleMap = ((RoleBasedAuthorizationStrategy)oldStrategy).getRoleMap(RoleBasedAuthorizationStrategy.GLOBAL);
                    if (roleMap == null || (sids = roleMap.getSidsForRole(roleName)) == null) continue;
                    for (String sid : sids) {
                        strategy.assignRole(RoleBasedAuthorizationStrategy.GLOBAL, role, sid);
                    }
                }
                this.ReadRoles(formData, RoleBasedAuthorizationStrategy.PROJECT, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
                this.ReadRoles(formData, RoleBasedAuthorizationStrategy.SLAVE, strategy, (RoleBasedAuthorizationStrategy)oldStrategy);
            } else if (oldStrategy instanceof RoleBasedAuthorizationStrategy) {
                strategy = (RoleBasedAuthorizationStrategy)oldStrategy;
            } else {
                strategy = new RoleBasedAuthorizationStrategy();
                Role adminRole = this.createAdminRole();
                strategy.addRole(RoleBasedAuthorizationStrategy.GLOBAL, adminRole);
                strategy.assignRole(RoleBasedAuthorizationStrategy.GLOBAL, adminRole, this.getCurrentUser());
            }
            strategy.renewMacroRoles();
            return strategy;
        }

        private void ReadRoles(JSONObject formData, String roleType, RoleBasedAuthorizationStrategy targetStrategy, RoleBasedAuthorizationStrategy oldStrategy) {
            if (!formData.has(roleType)) {
                assert (false) : "Unexistent Role type " + roleType;
                return;
            }
            JSONObject projectRoles = formData.getJSONObject(roleType);
            if (!projectRoles.containsKey((Object)"data")) {
                assert (false) : "No data at role description";
                return;
            }
            for (Map.Entry r : projectRoles.getJSONObject("data").entrySet()) {
                Set<String> sids;
                String roleName = (String)r.getKey();
                HashSet<Permission> permissions = new HashSet<Permission>();
                String pattern = ((JSONObject)r.getValue()).getString("pattern");
                if (pattern != null) {
                    ((JSONObject)r.getValue()).remove("pattern");
                } else {
                    pattern = ".*";
                }
                for (Map.Entry e : ((JSONObject)r.getValue()).entrySet()) {
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    permissions.add(p);
                }
                Role role = new Role(roleName, pattern, permissions);
                targetStrategy.addRole(roleType, role);
                RoleMap roleMap = oldStrategy.getRoleMap(roleType);
                if (roleMap == null || (sids = roleMap.getSidsForRole(roleName)) == null) continue;
                for (String sid : sids) {
                    targetStrategy.assignRole(roleType, role, sid);
                }
            }
        }

        private Role createAdminRole() {
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (PermissionGroup group : this.getGroups(RoleBasedAuthorizationStrategy.GLOBAL)) {
                for (Permission permission : group) {
                    permissions.add(permission);
                }
            }
            Role role = new Role("admin", permissions);
            return role;
        }

        private String getCurrentUser() {
            PrincipalSid currentUser = new PrincipalSid(Hudson.getAuthentication());
            return currentUser.getPrincipal();
        }

        @Nullable
        public List<PermissionGroup> getGroups(@Nonnull String type) {
            ArrayList<Object> groups;
            if (type.equals(RoleBasedAuthorizationStrategy.GLOBAL)) {
                groups = new ArrayList<PermissionGroup>(PermissionGroup.getAll());
                groups.remove(PermissionGroup.get(Permission.class));
            } else if (type.equals(RoleBasedAuthorizationStrategy.PROJECT)) {
                groups = new ArrayList(PermissionGroup.getAll());
                groups.remove(PermissionGroup.get(Permission.class));
                groups.remove(PermissionGroup.get(Hudson.class));
                groups.remove(PermissionGroup.get(Computer.class));
                groups.remove(PermissionGroup.get(View.class));
            } else if (type.equals(RoleBasedAuthorizationStrategy.SLAVE)) {
                groups = new ArrayList(PermissionGroup.getAll());
                groups.remove(PermissionGroup.get(Permission.class));
                groups.remove(PermissionGroup.get(Hudson.class));
                groups.remove(PermissionGroup.get(View.class));
                groups.remove(PermissionGroup.get(Item.class));
                groups.remove(PermissionGroup.get(SCM.class));
                groups.remove(PermissionGroup.get(Run.class));
            } else {
                groups = null;
            }
            return groups;
        }

        @Restricted(value={NoExternalUse.class})
        public boolean hasDangerousPermissions() {
            RoleBasedAuthorizationStrategy instance = RoleBasedAuthorizationStrategy.getInstance();
            if (instance == null) {
                return false;
            }
            return DangerousPermissionHelper.hasDangerousPermissions(instance);
        }

        @Restricted(value={NoExternalUse.class})
        public boolean showPermission(String type, Permission p) {
            return this.showPermission(type, p, false);
        }

        @Restricted(value={NoExternalUse.class})
        public boolean showPermission(String type, Permission p, boolean showDangerous) {
            if (type.equals(RoleBasedAuthorizationStrategy.GLOBAL)) {
                if (DangerousPermissionHelper.isDangerous(p)) {
                    RoleBasedAuthorizationStrategy instance = RoleBasedAuthorizationStrategy.getInstance();
                    if (instance == null) {
                        return false;
                    }
                    return showDangerous && DangerousPermissionHandlingMode.getCurrent() != DangerousPermissionHandlingMode.DISABLED;
                }
                return this.showPermission(p);
            }
            if (type.equals(RoleBasedAuthorizationStrategy.PROJECT)) {
                return p == Item.CREATE && RoleBasedAuthorizationStrategy.isCreateAllowed() && p.getEnabled() || p != Item.CREATE && p.getEnabled();
            }
            if (type.equals(RoleBasedAuthorizationStrategy.SLAVE)) {
                return p != Computer.CREATE && p.getEnabled();
            }
            return false;
        }
    }

    public static class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == RoleBasedAuthorizationStrategy.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            RoleBasedAuthorizationStrategy strategy = (RoleBasedAuthorizationStrategy)((Object)source);
            Map maps = strategy.getRoleMaps();
            for (Map.Entry map : maps.entrySet()) {
                RoleMap roleMap = (RoleMap)map.getValue();
                writer.startNode("roleMap");
                writer.addAttribute("type", (String)map.getKey());
                for (Map.Entry<Role, Set<String>> grantedRole : roleMap.getGrantedRoles().entrySet()) {
                    Role role = grantedRole.getKey();
                    if (role == null) continue;
                    writer.startNode("role");
                    writer.addAttribute("name", role.getName());
                    writer.addAttribute("pattern", role.getPattern().pattern());
                    writer.startNode("permissions");
                    for (Permission permission : role.getPermissions()) {
                        writer.startNode("permission");
                        writer.setValue(permission.getId());
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.startNode("assignedSIDs");
                    for (String sid : grantedRole.getValue()) {
                        writer.startNode("sid");
                        writer.setValue(sid);
                        writer.endNode();
                    }
                    writer.endNode();
                    writer.endNode();
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            RoleBasedAuthorizationStrategy strategy = this.create();
            boolean showDangerousPermissionsDefined = false;
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if (reader.getNodeName().equals("roleMap")) {
                    String type = reader.getAttribute("type");
                    RoleMap map = new RoleMap();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        String name = reader.getAttribute("name");
                        String pattern = reader.getAttribute("pattern");
                        HashSet<Permission> permissions = new HashSet<Permission>();
                        String next = reader.peekNextChild();
                        if (next != null && next.equals("permissions")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                Permission p = Permission.fromId((String)reader.getValue());
                                if (p != null) {
                                    permissions.add(p);
                                }
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        Role role = new Role(name, pattern, permissions);
                        map.addRole(role);
                        next = reader.peekNextChild();
                        if (next != null && next.equals("assignedSIDs")) {
                            reader.moveDown();
                            while (reader.hasMoreChildren()) {
                                reader.moveDown();
                                map.assignRole(role, reader.getValue());
                                reader.moveUp();
                            }
                            reader.moveUp();
                        }
                        reader.moveUp();
                    }
                    strategy.grantedRoles.put(type, map);
                }
                reader.moveUp();
            }
            return strategy;
        }

        protected RoleBasedAuthorizationStrategy create() {
            return new RoleBasedAuthorizationStrategy();
        }
    }
}

