/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import com.synopsys.arc.jenkins.plugins.rolestrategy.UserMacroExtension;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.security.AuthorizationStrategy;
import hudson.util.FormApply;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class RoleStrategyConfig
extends ManagementLink {
    public String getIconFileName() {
        String icon = null;
        if (Hudson.getInstance().getAuthorizationStrategy() instanceof RoleBasedAuthorizationStrategy) {
            icon = "secure.gif";
        }
        return icon;
    }

    public String getUrlName() {
        return "role-strategy";
    }

    public String getDisplayName() {
        return Messages.RoleBasedAuthorizationStrategy_ManageAndAssign();
    }

    public String getAssignRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Assign();
    }

    public String getManageRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Manage();
    }

    public String getDescription() {
        return Messages.RoleBasedAuthorizationStrategy_Description();
    }

    public AuthorizationStrategy getStrategy() {
        AuthorizationStrategy strategy = Hudson.getInstance().getAuthorizationStrategy();
        if (strategy instanceof RoleBasedAuthorizationStrategy) {
            return strategy;
        }
        return null;
    }

    public void doRolesSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Hudson.getInstance().checkPermission(Jenkins.ADMINISTER);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doRolesSubmit(req, rsp);
        FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
    }

    public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Hudson.getInstance().checkPermission(Jenkins.ADMINISTER);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doAssignSubmit(req, rsp);
        FormApply.success((String)".").generateResponse(req, rsp, (Object)this);
    }

    public ExtensionList<RoleMacroExtension> getRoleMacroExtensions() {
        return RoleMacroExtension.all();
    }

    @Deprecated
    public ExtensionList<UserMacroExtension> getUserMacroExtensions() {
        return UserMacroExtension.all();
    }

    public final RoleType getGlobalRoleType() {
        return RoleType.Global;
    }

    public final RoleType getProjectRoleType() {
        return RoleType.Project;
    }

    public final RoleType getSlaveRoleType() {
        return RoleType.Slave;
    }
}

