/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import hudson.security.Permission;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;

public final class Role
implements Comparable {
    public static final String GLOBAL_ROLE_PATTERN = ".*";
    private final String name;
    private final Pattern pattern;
    private final Set<Permission> permissions = new HashSet<Permission>();
    private transient Integer cachedHashCode = null;

    Role(String name, Set<Permission> permissions) {
        this(name, GLOBAL_ROLE_PATTERN, permissions);
    }

    Role(String name, String pattern, Set<Permission> permissions) {
        this(name, Pattern.compile(pattern), permissions);
    }

    Role(String name, Pattern pattern, Set<Permission> permissions) {
        this.name = name;
        this.pattern = pattern;
        this.permissions.addAll(permissions);
    }

    public final String getName() {
        return this.name;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public final Set<Permission> getPermissions() {
        return this.permissions;
    }

    public final Boolean hasPermission(Permission permission) {
        return this.permissions.contains(permission);
    }

    public final Boolean hasAnyPermission(Set<Permission> permissions) {
        return CollectionUtils.containsAny(this.permissions, permissions);
    }

    public int compareTo(Object o) {
        if (o instanceof Role) {
            return this.name.compareTo(((Role)o).name);
        }
        return -1;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = this._hashCode();
        }
        return this.cachedHashCode;
    }

    private int _hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 53 * hash + (this.pattern != null ? this.pattern.hashCode() : 0);
        hash = 53 * hash + (this.permissions != null ? this.permissions.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Role other = (Role)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!(this.pattern == other.pattern || this.pattern != null && this.pattern.equals(other.pattern))) {
            return false;
        }
        return this.permissions == other.permissions || this.permissions != null && this.permissions.equals(other.permissions);
    }
}

