/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.Role;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import hudson.Extension;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.security.AuthorizationStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.model.ProjectNamingStrategy;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class RoleBasedProjectNamingStrategy
extends ProjectNamingStrategy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean forceExistingJobs;

    @DataBoundConstructor
    public RoleBasedProjectNamingStrategy(boolean forceExistingJobs) {
        this.forceExistingJobs = forceExistingJobs;
    }

    public void checkName(String name) throws Failure {
        boolean matches = false;
        ArrayList<String> badList = null;
        AuthorizationStrategy auth = Jenkins.getInstance().getAuthorizationStrategy();
        if (auth instanceof RoleBasedAuthorizationStrategy) {
            RoleBasedAuthorizationStrategy rbas = (RoleBasedAuthorizationStrategy)auth;
            SortedMap<Role, Set<String>> gRole = rbas.getGrantedRoles("globalRoles");
            for (Map.Entry<Role, Set<String>> entry : gRole.entrySet()) {
                if (!entry.getKey().hasPermission(Item.CREATE).booleanValue()) continue;
                return;
            }
            SortedMap<Role, Set<String>> roles = rbas.getGrantedRoles("projectRoles");
            badList = new ArrayList<String>(roles.size());
            for (Map.Entry<Role, Set<String>> entry : roles.entrySet()) {
                String namePattern;
                Role key = entry.getKey();
                if (!key.hasPermission(Item.CREATE).booleanValue() || !StringUtils.isNotBlank((String)(namePattern = key.getPattern().toString())) || !StringUtils.isNotBlank((String)name)) continue;
                if (Pattern.matches(namePattern, name)) {
                    matches = true;
                    continue;
                }
                badList.add(namePattern);
            }
        }
        if (!matches) {
            String error = badList != null && !badList.isEmpty() ? jenkins.model.Messages.Hudson_JobNameConventionNotApplyed((Object)name, (Object)badList.toString()) : Messages.RoleBasedProjectNamingStrategy_NoPermissions();
            throw new Failure(error);
        }
    }

    public boolean isForceExistingJobs() {
        return this.forceExistingJobs;
    }

    @Extension
    public static final class DescriptorImpl
    extends ProjectNamingStrategy.ProjectNamingStrategyDescriptor {
        public String getDisplayName() {
            String name = Messages.RoleBasedAuthorizationStrategy_DisplayName();
            if (!RoleBasedAuthorizationStrategy.isCreateAllowed()) {
                name = name + " (<font color=\"red\">(Require >1.565 core)</font>";
            }
            return name;
        }
    }
}

