/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.rolestrategy;

import com.michelin.cio.hudson.plugins.rolestrategy.Messages;
import com.michelin.cio.hudson.plugins.rolestrategy.RoleBasedAuthorizationStrategy;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ManagementLink;
import hudson.security.AuthorizationStrategy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class RoleStrategyConfig
extends ManagementLink {
    public String getIconFileName() {
        String icon = null;
        if (Hudson.getInstance().getAuthorizationStrategy() instanceof RoleBasedAuthorizationStrategy) {
            icon = "secure.gif";
        }
        return icon;
    }

    public String getUrlName() {
        return "role-strategy";
    }

    public String getDisplayName() {
        return Messages.RoleBasedAuthorizationStrategy_ManageAndAssign();
    }

    public String getAssignRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Assign();
    }

    public String getManageRolesName() {
        return Messages.RoleBasedAuthorizationStrategy_Manage();
    }

    public String getDescription() {
        return Messages.RoleBasedAuthorizationStrategy_Description();
    }

    public AuthorizationStrategy getStrategy() {
        AuthorizationStrategy strategy = Hudson.getInstance().getAuthorizationStrategy();
        if (strategy instanceof RoleBasedAuthorizationStrategy) {
            return strategy;
        }
        return null;
    }

    public void doRolesSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doRolesSubmit(req, rsp);
        rsp.sendRedirect(".");
    }

    public void doAssignSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        RoleBasedAuthorizationStrategy.DESCRIPTOR.doAssignSubmit(req, rsp);
        rsp.sendRedirect(".");
    }
}

