/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.robot.AggregatedRobotAction;
import hudson.plugins.robot.Messages;
import hudson.plugins.robot.RobotBuildAction;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.Calendar;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RobotProjectAction
implements Action {
    private AbstractProject<?, ?> project;

    public RobotProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public boolean isDisplayGraph() {
        return this.getLastBuildAction() != null;
    }

    public Action getLastBuildAction() {
        AbstractBuild<?, ?> lastBuild = this.getLastBuildWithRobot();
        if (lastBuild != null) {
            RobotBuildAction action = (RobotBuildAction)lastBuild.getAction(RobotBuildAction.class);
            if (action == null) {
                return lastBuild.getAction(AggregatedRobotAction.class);
            }
            return action;
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Calendar t = ((AbstractBuild)this.project.getLastCompletedBuild()).getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        AbstractBuild<?, ?> lastBuild = this.getLastBuildWithRobot();
        rsp.sendRedirect2("../" + lastBuild.getNumber() + "/" + this.getUrlName() + "/graph?zoomSignificant=" + Boolean.valueOf(req.getParameter("zoomSignificant")) + "&hd=" + Boolean.valueOf(req.getParameter("hd")) + "&failedOnly=" + Boolean.valueOf(req.getParameter("failedOnly")) + "&criticalOnly=" + Boolean.valueOf(req.getParameter("criticalOnly")) + "&maxBuildsToShow=" + Integer.valueOf(req.getParameter("maxBuildsToShow")));
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        AbstractBuild<?, ?> lastBuild = this.getLastBuildWithRobot();
        if (lastBuild == null) {
            rsp.sendRedirect2("nodata");
        } else {
            int buildNumber = lastBuild.getNumber();
            rsp.sendRedirect2("../" + buildNumber + "/" + this.getUrlName());
        }
    }

    private AbstractBuild<?, ?> getLastBuildWithRobot() {
        AbstractBuild lastBuild;
        for (lastBuild = this.project.getLastBuild(); lastBuild != null && lastBuild.getAction(RobotBuildAction.class) == null && lastBuild.getAction(AggregatedRobotAction.class) == null; lastBuild = lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }

    public String getIconFileName() {
        return "/plugin/robot/robot.png";
    }

    public String getDisplayName() {
        return Messages.robot_sidebar_link();
    }

    public String getUrlName() {
        return "robot";
    }
}

