/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.plugins.robot.model.RobotCaseResult;
import hudson.plugins.robot.model.RobotResult;
import hudson.plugins.robot.model.RobotSuiteResult;
import hudson.plugins.robot.model.RobotTestObject;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.remoting.RoleChecker;

public class RobotParser {
    public RobotResult parse(String outputFileLocations, String outputPath, Run<?, ?> build, FilePath workSpace, String logFileName, String reportFileName) throws InterruptedException, IOException {
        RobotResult result = (RobotResult)new FilePath(workSpace, outputPath).act((FilePath.FileCallable)new RobotParserCallable(outputFileLocations, logFileName, reportFileName));
        return result;
    }

    public static final class RobotParserCallable
    implements FilePath.FileCallable<RobotResult> {
        private static final long serialVersionUID = 1L;
        private final String outputFileLocations;
        private final String logFileName;
        private final String reportFileName;

        public RobotParserCallable(String outputFileLocations, String logFileName, String reportFileName) {
            this.outputFileLocations = outputFileLocations;
            this.logFileName = logFileName;
            this.reportFileName = reportFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RobotResult invoke(File ws, VirtualChannel channel) throws IOException {
            FileSet setInWorkspace = Util.createFileSet((File)ws, (String)this.outputFileLocations);
            DirectoryScanner resultScanner = setInWorkspace.getDirectoryScanner();
            String[] files = resultScanner.getIncludedFiles();
            if (files.length == 0) {
                throw new AbortException("No files found in path " + ws.getAbsolutePath() + " with configured filemask: " + this.outputFileLocations);
            }
            RobotResult result = new RobotResult();
            result.setLogFile(this.logFileName);
            result.setReportFile(this.reportFileName);
            for (String file : files) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
                File baseDirectory = resultScanner.getBasedir();
                File reportFile = new File(baseDirectory, file);
                String dirFromFileGLOB = new File(file).getParent();
                if (dirFromFileGLOB != null) {
                    baseDirectory = new File(baseDirectory, dirFromFileGLOB.toString());
                }
                try (FileInputStream inputStream = new FileInputStream(reportFile);
                     XMLStreamReader reader = factory.createXMLStreamReader(inputStream, "UTF-8");){
                    this.parseResult(result, reader, baseDirectory);
                }
            }
            return result;
        }

        private RobotResult parseResult(RobotResult result, XMLStreamReader reader, File baseDirectory) throws XMLStreamException, IOException {
            while (reader.hasNext()) {
                reader.next();
                if (!reader.isStartElement()) continue;
                String tagName = reader.getLocalName();
                if ("statistics".equals(tagName)) break;
                if ("robot".equals(tagName)) {
                    result.setTimeStamp(reader.getAttributeValue(null, "generated"));
                    continue;
                }
                if (!"suite".equals(tagName)) continue;
                result.addSuite(this.processSuite(reader, result, baseDirectory));
            }
            return result;
        }

        private RobotSuiteResult processSuite(XMLStreamReader reader, RobotTestObject parent, File baseDirectory) throws IOException, XMLStreamException {
            String splitXMLPath = reader.getAttributeValue(null, "src");
            if (splitXMLPath != null) {
                return this.getSplitXMLSuite(parent, baseDirectory, splitXMLPath);
            }
            RobotSuiteResult suite = new RobotSuiteResult();
            suite.setLogFile(this.logFileName);
            suite.setReportFile(this.reportFileName);
            suite.setParent(parent);
            suite.setName(reader.getAttributeValue(null, "name"));
            suite.setId(reader.getAttributeValue(null, "id"));
            suite.setDescription("");
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement()) {
                    String tagName = reader.getLocalName();
                    if ("doc".equals(tagName)) {
                        reader.next();
                        if (!reader.hasText()) continue;
                        suite.setDescription(reader.getText());
                        continue;
                    }
                    if ("suite".equals(tagName)) {
                        suite.addChild(this.processSuite(reader, suite, baseDirectory));
                        continue;
                    }
                    if ("test".equals(tagName)) {
                        suite.addCaseResult(this.processTest(reader, suite));
                        continue;
                    }
                    if ("kw".equals(tagName) && "teardown".equals(reader.getAttributeValue(null, "type"))) {
                        this.ignoreUntilStarts(reader, "status");
                        if (!"FAIL".equals(reader.getAttributeValue(null, "status"))) continue;
                        suite.failTeardown();
                        continue;
                    }
                    if (!"status".equals(tagName)) continue;
                    suite.setElapsedTime(reader.getAttributeValue(null, "elapsedtime"));
                    suite.setStartTime(reader.getAttributeValue(null, "starttime"));
                    suite.setEndTime(reader.getAttributeValue(null, "endtime"));
                    continue;
                }
                if (!reader.isEndElement() || !"suite".equals(reader.getLocalName())) continue;
                return suite;
            }
            throw this.xmlException("No matching end tag found for test suite: " + suite.getName(), reader);
        }

        private XMLStreamException xmlException(String message, XMLStreamReader reader) {
            Location location = reader.getLocation();
            return new XMLStreamException(message + " (at line: " + location.getLineNumber() + " column: " + location.getColumnNumber() + ")");
        }

        private RobotSuiteResult getSplitXMLSuite(RobotTestObject parent, File baseDirectory, String path) throws XMLStreamException, IOException {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            try (FileInputStream inputStream = new FileInputStream(new File(baseDirectory, path));
                 XMLStreamReader splitReader = factory.createXMLStreamReader(inputStream, "UTF-8");){
                while (splitReader.hasNext()) {
                    splitReader.next();
                    if (!splitReader.isStartElement() || !"suite".equals(splitReader.getLocalName())) continue;
                    RobotSuiteResult robotSuiteResult = this.processSuite(splitReader, parent, baseDirectory);
                    return robotSuiteResult;
                }
                throw this.xmlException("Illegal split xml output. Could not find suite element.", splitReader);
            }
        }

        private String ignoreUntilStarts(XMLStreamReader reader, String ... elements) throws XMLStreamException {
            ArrayList<String> elementStack = new ArrayList<String>();
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement()) {
                    String elem = reader.getLocalName();
                    if (elementStack.isEmpty() && this.isNameInElements(elem, elements)) {
                        return elem;
                    }
                    elementStack.add(reader.getLocalName());
                    continue;
                }
                if (!reader.isEndElement()) continue;
                if (elementStack.isEmpty()) {
                    throw this.xmlException("Could not find elements " + Arrays.toString(elements), reader);
                }
                if (!((String)elementStack.get(elementStack.size() - 1)).equals(reader.getLocalName())) {
                    throw this.xmlException("Illegal xml input. End element " + reader.getLocalName() + " while waiting for element " + (String)elementStack.get(elementStack.size() - 1), reader);
                }
                elementStack.remove(elementStack.size() - 1);
            }
            throw this.xmlException("Could not find elements " + Arrays.toString(elements), reader);
        }

        private boolean isNameInElements(String name, String[] elements) {
            for (String element : elements) {
                if (!name.equals(element)) continue;
                return true;
            }
            return false;
        }

        private void ignoreUntilEnds(XMLStreamReader reader, String element) throws XMLStreamException {
            ArrayList<String> elementStack = new ArrayList<String>();
            while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement()) {
                    elementStack.add(reader.getLocalName());
                    continue;
                }
                if (!reader.isEndElement()) continue;
                String tagName = reader.getLocalName();
                if (elementStack.isEmpty()) {
                    if (tagName.equals(element)) {
                        return;
                    }
                    throw this.xmlException("Illegal xml input. Could not find end of element " + element + ". Unexpected end of element " + tagName, reader);
                }
                if (!((String)elementStack.get(elementStack.size() - 1)).equals(tagName)) {
                    throw this.xmlException("Illegal xml input. End element " + tagName + " while waiting for element " + (String)elementStack.get(elementStack.size() - 1), reader);
                }
                elementStack.remove(elementStack.size() - 1);
            }
            throw this.xmlException("Could not find end of element " + element, reader);
        }

        private RobotCaseResult processTest(XMLStreamReader reader, RobotSuiteResult result) throws XMLStreamException {
            RobotCaseResult caseResult = new RobotCaseResult();
            caseResult.setParent(result);
            caseResult.setLogFile(this.logFileName);
            caseResult.setName(reader.getAttributeValue(null, "name"));
            RobotParserCallable.setCriticalityIfAvailable(reader, caseResult);
            caseResult.setId(reader.getAttributeValue(null, "id"));
            caseResult.setDescription("");
            caseResult.addTags(new ArrayList<String>());
            String xmlTag = this.ignoreUntilStarts(reader, "doc", "tags", "status");
            if (xmlTag == "doc") {
                reader.next();
                if (reader.hasText()) {
                    caseResult.setDescription(reader.getText());
                }
                reader.next();
                xmlTag = this.ignoreUntilStarts(reader, "tags", "status");
            }
            if (xmlTag == "tags") {
                caseResult.addTags(this.processTags(reader));
                this.ignoreUntilStarts(reader, "status");
            }
            caseResult.setPassed("PASS".equals(reader.getAttributeValue(null, "status")));
            caseResult.setStarttime(reader.getAttributeValue(null, "starttime"));
            caseResult.setEndtime(reader.getAttributeValue(null, "endtime"));
            RobotParserCallable.setCriticalityIfAvailable(reader, caseResult);
            while (reader.hasNext()) {
                reader.next();
                if (reader.getEventType() == 4) {
                    String error = reader.getText();
                    caseResult.setErrorMsg(error);
                    continue;
                }
                if (!reader.isEndElement()) continue;
                if ("status".equals(reader.getLocalName())) break;
                throw this.xmlException("No end tag found for status while parsing test case: " + caseResult.getName(), reader);
            }
            this.ignoreUntilEnds(reader, "test");
            return caseResult;
        }

        private List<String> processTags(XMLStreamReader reader) throws XMLStreamException {
            ArrayList<String> taglist = new ArrayList<String>();
            block0: while (reader.hasNext()) {
                reader.next();
                if (reader.isStartElement() && "tag".equals(reader.getLocalName())) {
                    while (reader.hasNext()) {
                        reader.next();
                        if (reader.getEventType() == 4) {
                            taglist.add(reader.getText());
                            continue;
                        }
                        if (!reader.isEndElement() || !"tag".equals(reader.getLocalName())) continue;
                        continue block0;
                    }
                    continue;
                }
                if (!reader.isEndElement() || !"tags".equals(reader.getLocalName())) continue;
                break;
            }
            return taglist;
        }

        private static void setCriticalityIfAvailable(XMLStreamReader reader, RobotCaseResult caseResult) {
            String criticality = reader.getAttributeValue(null, "critical");
            if (criticality != null) {
                if (criticality.equals("yes")) {
                    caseResult.setCritical(true);
                } else {
                    caseResult.setCritical(false);
                }
            }
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }
}

