/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.robot;

import hudson.Extension;
import hudson.model.Descriptor;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class RobotConfig
extends GlobalConfiguration {
    private boolean robotResultsColumnEnabled = true;
    private int buildsToShowInResultsColumn = 15;
    private String xAxisLabelFormat = "#$build";

    public RobotConfig() {
        this.load();
    }

    public static RobotConfig getInstance() {
        return (RobotConfig)((Object)GlobalConfiguration.all().get(RobotConfig.class));
    }

    public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
        o = o.getJSONObject("robotFramework");
        this.robotResultsColumnEnabled = o.getBoolean("robotResultsColumnEnabled");
        this.buildsToShowInResultsColumn = o.getInt("buildsToShowInResultsColumn");
        this.xAxisLabelFormat = o.getString("xAxisLabelFormat");
        this.save();
        return super.configure(req, o);
    }

    public int getBuildsToShowInResultsColumn() {
        return this.buildsToShowInResultsColumn;
    }

    public boolean isRobotResultsColumnEnabled() {
        return this.robotResultsColumnEnabled;
    }

    public String getXAxisLabelFormat() {
        return this.xAxisLabelFormat;
    }

    public void setBuildsToShowInResultsColumn(int buildsToShowInResultsColumn) {
        this.buildsToShowInResultsColumn = buildsToShowInResultsColumn;
    }

    public void setRobotResultsColumnEnabled(boolean robotResultsColumnEnabled) {
        this.robotResultsColumnEnabled = robotResultsColumnEnabled;
    }

    public void setXAxisLabelFormat(String xAxisLabelFormat) {
        this.xAxisLabelFormat = xAxisLabelFormat;
    }
}

