/*
 * Decompiled with CFR 0.152.
 */
package org.korosoft.jenkins.plugin.rtp.parser;

import java.io.FileNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import org.korosoft.jenkins.plugin.rtp.MarkupParser;
import org.korosoft.jenkins.plugin.rtp.Messages;
import org.sweble.wikitext.engine.CompiledPage;
import org.sweble.wikitext.engine.Compiler;
import org.sweble.wikitext.engine.PageId;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.engine.utils.HtmlPrinter;
import org.sweble.wikitext.engine.utils.SimpleWikiConfiguration;

public class WikiTextMarkupParser
implements MarkupParser {
    private SimpleWikiConfiguration config;
    private Compiler compiler;

    private void init() {
        try {
            this.config = new SimpleWikiConfiguration("classpath:/org/sweble/wikitext/engine/SimpleWikiConfiguration.xml");
            this.compiler = new Compiler((WikiConfigurationInterface)this.config);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public String parse(String markupText) {
        if (this.config == null || this.compiler == null) {
            this.init();
        }
        try {
            PageTitle pageTitle = PageTitle.make((WikiConfigurationInterface)this.config, (String)"PageTitle");
            PageId pageId = new PageId(pageTitle, -1L);
            CompiledPage cp = this.compiler.postprocess(pageId, markupText, null);
            StringWriter w = new StringWriter();
            HtmlPrinter p = new HtmlPrinter((Writer)w, pageTitle.getFullTitle());
            p.setStandaloneHtml(false, "");
            p.go((Object)cp.getPage());
            return w.toString();
        }
        catch (Exception e) {
            return "<b>" + Messages.failedToCompile() + "</b><br/>" + e.toString();
        }
    }

    public String getName() {
        return Messages.wikiText();
    }
}

