/*
 * Decompiled with CFR 0.152.
 */
package org.korosoft.jenkins.plugin.rtp;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.korosoft.jenkins.plugin.rtp.MarkupParser;
import org.korosoft.jenkins.plugin.rtp.Messages;

public class StaticTextPortlet
extends DashboardPortlet {
    private static final Log log = LogFactory.getLog(StaticTextPortlet.class);
    private String text;
    private String richText;
    private String parserName;
    private transient MarkupParser markupParser;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.parserName != null) {
            this.richText = this.getMarkupParser().parse(text);
        }
    }

    public String getRichText() {
        return this.richText;
    }

    public String getParserName() {
        return this.parserName;
    }

    public void setParserName(String parserName) {
        if (parserName == null || !DescriptorImpl.markupParsers.containsKey(parserName)) {
            parserName = "HTML";
        }
        this.parserName = parserName;
        this.markupParser = (MarkupParser)DescriptorImpl.markupParsers.get(parserName);
        if (this.text != null) {
            this.richText = this.getMarkupParser().parse(this.text);
        }
    }

    @DataBoundConstructor
    public StaticTextPortlet(String name, String text, String parserName) {
        super(name);
        this.text = text;
        this.setParserName(parserName);
        this.richText = this.getMarkupParser().parse(text);
    }

    private MarkupParser getMarkupParser() {
        if (this.markupParser == null) {
            this.markupParser = (MarkupParser)DescriptorImpl.markupParsers.get(this.parserName);
        }
        return this.markupParser;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        private static transient Map<String, MarkupParser> markupParsers;
        private static transient List<String> markupParserNames;

        private static void loadParsers() {
            Properties properties = new Properties();
            InputStream stream = DescriptorImpl.class.getResourceAsStream("/parsers.properties");
            try {
                properties.load(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            markupParsers = new HashMap<String, MarkupParser>();
            markupParserNames = new ArrayList<String>();
            for (Object o : properties.values()) {
                try {
                    MarkupParser parser = (MarkupParser)Class.forName(o.toString()).newInstance();
                    String name = parser.getName();
                    markupParserNames.add(name);
                    markupParsers.put(name, parser);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }

        public HttpResponse doFillParserNameItems() {
            DescriptorImpl.loadParsers();
            ListBoxModel model = new ListBoxModel();
            for (String name : markupParserNames) {
                model.add(name, name);
            }
            return model;
        }

        public String getDisplayName() {
            return Messages.richText();
        }

        static {
            DescriptorImpl.loadParsers();
        }
    }
}

