/*
 * Decompiled with CFR 0.152.
 */
package org.korosoft.jenkins.plugin.rtp;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.korosoft.jenkins.plugin.rtp.BuildRichTextAction;
import org.korosoft.jenkins.plugin.rtp.MarkupParser;
import org.korosoft.jenkins.plugin.rtp.Messages;
import org.korosoft.jenkins.plugin.rtp.ProjectRichTextAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextPublisher
extends Recorder {
    private static final Log log = LogFactory.getLog(RichTextPublisher.class);
    private static final transient Pattern FILE_VAR_PATTERN = Pattern.compile("\\$\\{(file|file_sl):([^\\}]+)\\}", 2);
    private String stableText;
    private String unstableText;
    private String failedText;
    private Boolean unstableAsStable = true;
    private Boolean failedAsStable = true;
    private String parserName;
    private transient MarkupParser markupParser;

    @DataBoundConstructor
    public RichTextPublisher(String stableText, String unstableText, String failedText, Boolean unstableAsStable, Boolean failedAsStable, String parserName) {
        this.stableText = stableText;
        this.unstableText = unstableText;
        this.failedText = failedText;
        this.unstableAsStable = unstableAsStable == null ? true : unstableAsStable;
        this.failedAsStable = failedAsStable == null ? true : failedAsStable;
        this.setParserName(parserName);
    }

    public List<String> getMarkupParserNames() {
        return DescriptorImpl.markupParserNames;
    }

    public String getStableText() {
        return this.stableText;
    }

    public void setStableText(String stableText) {
        this.stableText = stableText;
    }

    public String getUnstableText() {
        return this.unstableText;
    }

    public void setUnstableText(String unstableText) {
        this.unstableText = unstableText;
    }

    public String getFailedText() {
        return this.failedText;
    }

    public void setFailedText(String failedText) {
        this.failedText = failedText;
    }

    public boolean isUnstableAsStable() {
        return this.unstableAsStable;
    }

    public void setUnstableAsStable(boolean unstableAsStable) {
        this.unstableAsStable = unstableAsStable;
    }

    public boolean isFailedAsStable() {
        return this.failedAsStable;
    }

    public void setFailedAsStable(boolean failedAsStable) {
        this.failedAsStable = failedAsStable;
    }

    public String getParserName() {
        return this.parserName;
    }

    public void setParserName(String parserName) {
        if (parserName == null || !DescriptorImpl.markupParsers.containsKey(parserName)) {
            parserName = "HTML";
        }
        this.parserName = parserName;
        this.markupParser = (MarkupParser)DescriptorImpl.markupParsers.get(parserName);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        String text = build.getResult().isBetterOrEqualTo(Result.SUCCESS) ? this.stableText : (build.getResult().isBetterOrEqualTo(Result.UNSTABLE) ? (this.unstableAsStable != false ? this.stableText : this.unstableText) : (this.failedAsStable != false ? this.stableText : this.failedText));
        HashMap<String, String> vars = new HashMap<String, String>();
        for (Map.Entry entry : build.getEnvironment((TaskListener)listener).entrySet()) {
            vars.put(String.format("ENV:%s", entry.getKey()), (String)entry.getValue());
        }
        vars.putAll(build.getBuildVariables());
        Matcher matcher = FILE_VAR_PATTERN.matcher(text);
        int start = 0;
        while (matcher.find(start)) {
            String fileName = matcher.group(2);
            FilePath filePath = new FilePath(build.getWorkspace(), fileName);
            if (filePath.exists()) {
                String value = filePath.readToString();
                if (matcher.group(1).length() != 4) {
                    value = value.replace("\n", "").replace("\r", "");
                }
                vars.put(String.format("%s:%s", matcher.group(1), fileName), value);
            }
            start = matcher.end();
        }
        BuildRichTextAction action = new BuildRichTextAction(build, this.getMarkupParser().parse(this.replaceVars(text, vars)));
        build.addAction((Action)action);
        build.save();
        return true;
    }

    private MarkupParser getMarkupParser() {
        if (this.markupParser == null) {
            this.markupParser = (MarkupParser)DescriptorImpl.markupParsers.get(this.parserName);
        }
        return this.markupParser;
    }

    private String replaceVars(String publishText, Map<String, String> vars) {
        for (Map.Entry<String, String> var : vars.entrySet()) {
            String key = String.format("${%s}", var.getKey());
            String value = var.getValue();
            publishText = publishText.replace(key, value);
        }
        return publishText;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singletonList(new ProjectRichTextAction(project, this.stableText));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static transient Map<String, MarkupParser> markupParsers;
        private static transient List<String> markupParserNames;

        private static void loadParsers() {
            Properties properties = new Properties();
            InputStream stream = DescriptorImpl.class.getResourceAsStream("/parsers.properties");
            try {
                properties.load(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
            markupParsers = new HashMap<String, MarkupParser>();
            markupParserNames = new ArrayList<String>();
            for (Object o : properties.values()) {
                try {
                    MarkupParser parser = (MarkupParser)Class.forName(o.toString()).newInstance();
                    String name = parser.getName();
                    markupParserNames.add(name);
                    markupParsers.put(name, parser);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }

        public HttpResponse doFillParserNameItems() {
            DescriptorImpl.loadParsers();
            ListBoxModel model = new ListBoxModel();
            for (String name : markupParserNames) {
                model.add(name, name);
            }
            return model;
        }

        public FormValidation doCheckPublishText(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            try {
                FilePath workspace = project.getSomeWorkspace();
                if (workspace == null) {
                    return FormValidation.warning((String)Messages.neverBuilt());
                }
                Matcher matcher = FILE_VAR_PATTERN.matcher(value);
                int start = 0;
                ArrayList<String> missingFiles = new ArrayList<String>();
                while (matcher.find(start)) {
                    String fileName = matcher.group(2);
                    FilePath filePath = new FilePath(workspace, fileName);
                    if (!filePath.exists()) {
                        missingFiles.add(fileName);
                    }
                    start = matcher.end();
                }
                if (missingFiles.isEmpty()) {
                    return FormValidation.ok();
                }
                if (missingFiles.size() == 1) {
                    return FormValidation.warning((String)Messages.fileNotFound(), (Object[])new Object[]{missingFiles.get(0)});
                }
                return FormValidation.warning((String)Messages.filesNotFound(), (Object[])new Object[]{StringUtils.join(missingFiles, (String)", ")});
            }
            catch (InterruptedException e) {
                return FormValidation.error((Throwable)e, (String)Messages.interrupted());
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.publish();
        }

        static {
            DescriptorImpl.loadParsers();
        }
    }
}

