/*
 * Decompiled with CFR 0.152.
 */
package org.korosoft.jenkins.plugin.rtp;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.korosoft.jenkins.plugin.rtp.AbstractRichTextAction;
import org.korosoft.jenkins.plugin.rtp.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextPortlet
extends DashboardPortlet {
    private String jobName;
    private boolean useLastStable;

    public String getJobName() {
        return this.jobName;
    }

    public boolean isUseLastStable() {
        return this.useLastStable;
    }

    public String getRichText() {
        try {
            TopLevelItem item = Jenkins.getInstance().getItem(this.jobName);
            if (!(item instanceof AbstractProject)) {
                return String.format(Messages.jobNotFound(), this.jobName);
            }
            AbstractProject project = (AbstractProject)item;
            if (!this.useLastStable) {
                return this.getRichTextFromActions(project.getActions());
            }
            for (AbstractBuild abstractBuild : project.getBuilds()) {
                if (!abstractBuild.getResult().isBetterOrEqualTo(Result.SUCCESS)) continue;
                return this.getRichTextFromActions(abstractBuild.getActions());
            }
            return Messages.noStableBuildsYet();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private String getRichTextFromActions(List<Action> actions) {
        StringBuilder result = new StringBuilder();
        for (Action action : actions) {
            if (!(action instanceof AbstractRichTextAction)) continue;
            result.append(((AbstractRichTextAction)action).getRichText());
        }
        return result.toString();
    }

    @DataBoundConstructor
    public RichTextPortlet(String name, String jobName, boolean useLastStable) {
        super(name);
        this.jobName = jobName;
        this.useLastStable = useLastStable;
    }

    public static Collection<String> getAllJobNames() {
        return Jenkins.getInstance().getJobNames();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.buildPortletTitle();
        }

        public FormValidation doCheckJobName(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.noJobName());
            }
            if (!RichTextPortlet.getAllJobNames().contains(value)) {
                return FormValidation.error((String)String.format(Messages.jobNotFound(), value));
            }
            return FormValidation.ok();
        }
    }
}

