/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.rhnpush;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jenkins.model.Jenkins;
import jenkins.plugins.rhnpush.Messages;
import jenkins.plugins.rhnpush.RhnPushEntry;
import jenkins.plugins.rhnpush.SatelliteServer;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class RhnPush
extends Recorder {
    private final boolean newest;
    private List<RhnPushEntry> entries = Collections.emptyList();
    private final boolean deployEvenBuildFail;
    private final boolean noGpg;
    private final boolean force;
    private String server;
    private String proxy;
    private String username;
    private Secret password;
    private final String serverType;
    private String satelliteServerHostname;

    @DataBoundConstructor
    public RhnPush(String serverType, String satelliteServerHostname, String server, String proxy, String username, Secret password, boolean deployEvenBuildFail, boolean noGpg, boolean newest, boolean force, List<RhnPushEntry> publishedRpms) {
        this.entries = publishedRpms;
        this.deployEvenBuildFail = deployEvenBuildFail;
        this.noGpg = noGpg;
        this.newest = newest;
        this.force = force;
        if (this.entries == null) {
            this.entries = Collections.emptyList();
        }
        this.serverType = serverType;
        if (serverType.toLowerCase().equals("build")) {
            this.server = server;
            this.proxy = proxy;
            this.username = username;
            this.password = password;
        } else {
            this.satelliteServerHostname = satelliteServerHostname;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private boolean isPerformDeployment(AbstractBuild build) {
        Result result = build.getResult();
        return result == null || this.isDeployEvenBuildFail() || result.isBetterOrEqualTo(Result.UNSTABLE);
    }

    public List<RhnPushEntry> getEntries() {
        return this.entries;
    }

    public boolean isDeployEvenBuildFail() {
        return this.deployEvenBuildFail;
    }

    public boolean isNoGpg() {
        return this.noGpg;
    }

    public boolean isNewest() {
        return this.newest;
    }

    public boolean isForce() {
        return this.force;
    }

    public String getServer() {
        return this.server;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (!this.isPerformDeployment(build)) {
            listener.getLogger().println("[RhnPush] - Skipping publishing RPMs ...");
            return true;
        }
        listener.getLogger().println("[RhnPush] - Starting publishing RPMs ...");
        Iterator<RhnPushEntry> iterator = this.entries.iterator();
        block0: while (true) {
            if (!iterator.hasNext()) {
                listener.getLogger().println("[RhnPush] - Finished publishing RPMs ...");
                return true;
            }
            RhnPushEntry entry = iterator.next();
            StringTokenizer rpmGlobTokenizer = new StringTokenizer(entry.getIncludes(), ",");
            while (true) {
                if (!rpmGlobTokenizer.hasMoreTokens()) continue block0;
                String rpmGlob = rpmGlobTokenizer.nextToken();
                listener.getLogger().println("[RhnPush] - Publishing " + rpmGlob);
                FilePath workspace = build.getWorkspace();
                if (workspace == null) {
                    throw new IllegalStateException("Could not get a workspace.");
                }
                Object[] matchedRpms = workspace.list(rpmGlob);
                if (ArrayUtils.isEmpty((Object[])matchedRpms)) {
                    listener.getLogger().println("[RhnPush] - No RPMs matching " + rpmGlob);
                    continue;
                }
                ArgumentListBuilder command = new ArgumentListBuilder();
                command.add("rhnpush");
                if (this.getServerType().toLowerCase().equals("global")) {
                    SatelliteServer ss = this.getSatelliteServer();
                    if (ss == null) {
                        listener.getLogger().println("[RhnPush] - Unknown global satellite server " + this.getSatelliteServerHostname() + " ...");
                        return false;
                    }
                    command.add(new String[]{"--server=" + ss.getHostname(), "-u", ss.getUsername(), "-p"});
                    command.addMasked(ss.getPassword().getPlainText());
                    if (!ss.getProxy().isEmpty()) {
                        command.add("--proxy=" + ss.getProxy());
                    }
                } else {
                    command.add(new String[]{"--server=" + this.server, "-u", this.getUsername(), "-p"});
                    command.addMasked(this.getPassword().getPlainText());
                    if (this.proxy != null && !this.proxy.isEmpty()) {
                        command.add("--proxy=" + this.proxy);
                    }
                }
                StringTokenizer channelTokenizer = new StringTokenizer(entry.getChannels(), ",");
                while (channelTokenizer.hasMoreTokens()) {
                    command.add("-c");
                    command.add(channelTokenizer.nextToken().trim());
                }
                if (this.isNoGpg()) {
                    command.add("--nosig");
                }
                if (this.isNewest()) {
                    command.add("--newest");
                }
                if (this.isForce()) {
                    command.add("--force");
                }
                for (Object rpmFilePath : matchedRpms) {
                    command.add(rpmFilePath.toURI().normalize().getPath());
                }
                Launcher.ProcStarter ps = new Launcher.ProcStarter(launcher);
                ps = ps.cmds(command).stdout((TaskListener)listener);
                Proc proc = launcher.launch(ps = ps.pwd(build.getWorkspace()).envs((Map)build.getEnvironment((TaskListener)listener)));
                int retcode = proc.join();
                if (retcode != 0) break block0;
            }
            break;
        }
        listener.getLogger().println("[RhnPush] - Failed publishing RPMs ...");
        return false;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getSatelliteServerHostname() {
        return this.satelliteServerHostname;
    }

    private SatelliteServer getSatelliteServer() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Could not get a Jenkins instance.");
        }
        RpmPublisherDescriptor rpmPublisherDescriptor = (RpmPublisherDescriptor)jenkins.getDescriptorByType(RpmPublisherDescriptor.class);
        if (!StringUtils.isEmpty((String)this.getSatelliteServerHostname()) && !rpmPublisherDescriptor.getSatelliteServers().isEmpty()) {
            for (SatelliteServer ss : rpmPublisherDescriptor.getSatelliteServers()) {
                if (!StringUtils.equals((String)this.getSatelliteServerHostname(), (String)ss.getHostname())) continue;
                return ss;
            }
        }
        return null;
    }

    @Extension
    public static final class RpmPublisherDescriptor
    extends BuildStepDescriptor<Publisher> {
        public static final String DISPLAY_NAME = Messages.rhnpushpublisher_displayName();
        private volatile List<SatelliteServer> satelliteServers = new ArrayList<SatelliteServer>();

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public RpmPublisherDescriptor() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.rhnpushpublisher_displayName();
        }

        public List<SatelliteServer> getSatelliteServers() {
            return this.satelliteServers;
        }

        public ListBoxModel doFillSatelliteServerHostnameItems() {
            ListBoxModel items = new ListBoxModel();
            for (SatelliteServer satelliteServer : this.satelliteServers) {
                items.add(satelliteServer.getHostname(), satelliteServer.getHostname());
            }
            return items;
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.satelliteServers = req.bindJSONToList(SatelliteServer.class, json.get("satelliteServer"));
            this.save();
            return true;
        }

        public FormValidation doCheckHostname(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckServer(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckUsername(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckPassword(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckChannels(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckIncludes(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, InterruptedException {
            FilePath workspace = project.getWorkspace();
            if (workspace == null) {
                throw new IllegalStateException("Could not get a workspace.");
            }
            String msg = workspace.validateAntFileMask(value);
            if (msg != null) {
                return FormValidation.error((String)msg);
            }
            return FormValidation.ok();
        }
    }
}

