/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.reverse_proxy_auth.service;

import hudson.Util;
import hudson.security.SecurityRealm;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;

public class ProxyLDAPAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;

    public ProxyLDAPAuthoritiesPopulator(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
        super(initialDirContextFactory, Util.fixNull((String)groupSearchBase));
        super.setRolePrefix("");
        super.setConvertToUpperCase(false);
    }

    protected Set getAdditionalRoles(LdapUserDetails ldapUser) {
        return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY);
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public Set getGroupMembershipRoles(String userDn, String username) {
        Set names = super.getGroupMembershipRoles(userDn, username);
        HashSet<GrantedAuthorityImpl> r = new HashSet<GrantedAuthorityImpl>(names.size() * 2);
        r.addAll(names);
        for (GrantedAuthority ga : names) {
            String role = ga.getAuthority();
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            r.add(new GrantedAuthorityImpl(this.rolePrefix + role));
        }
        return r;
    }
}

