/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import com.michelin.cio.jenkins.plugin.requests.RequestsPlugin;
import com.michelin.cio.jenkins.plugin.requests.action.Messages;
import com.michelin.cio.jenkins.plugin.requests.model.DeleteBuildRequest;
import com.michelin.cio.jenkins.plugin.requests.model.RequestsUtility;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Run;
import hudson.security.Permission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RequestDeleteBuildAction
implements Action {
    private Run<?, ?> build;
    private transient List<String> errors = new ArrayList<String>();
    private static final Logger LOGGER = Logger.getLogger(RequestDeleteBuildAction.class.getName());

    public RequestDeleteBuildAction(Run<?, ?> target) {
        this.build = target;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(String errorString) {
        this.errors.clear();
        this.errors.add(errorString);
    }

    @RequirePOST
    public HttpResponse doCreateDeleteBuildRequest(StaplerRequest request, StaplerResponse response) throws IOException, ServletException, MessagingException {
        try {
            if (this.isIconDisplayed()) {
                String projectFullName;
                LOGGER.log(Level.FINE, "Delete Build request");
                this.errors.clear();
                String username = request.getParameter("username");
                RequestsPlugin plugin = (RequestsPlugin)Jenkins.get().getPlugin(RequestsPlugin.class);
                String[] nameList = null;
                String buildName = this.build.getDisplayName();
                String projectName = "";
                int buildNumber = this.build.getNumber();
                String fullDisplayName = this.build.getFullDisplayName();
                if (fullDisplayName.contains(" \u00bb ")) {
                    RequestsUtility requestsUtility = new RequestsUtility();
                    nameList = requestsUtility.constructFolderJobNameAndFull(fullDisplayName);
                    projectName = nameList[0];
                    projectFullName = nameList[1];
                } else {
                    projectName = projectFullName = fullDisplayName.split(" #")[0];
                }
                String jenkinsUrl = Jenkins.get().getRootUrl();
                String buildUrl = jenkinsUrl + this.build.getUrl();
                String[] emailData = new String[]{buildName, username, "A Delete Build", buildUrl};
                plugin.addRequestPlusEmail(new DeleteBuildRequest("deleteBuild", username, projectName, projectFullName, Integer.toString(buildNumber)), emailData);
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "Exception: " + e.getMessage());
            return null;
        }
        return new HttpRedirect(request.getContextPath() + '/' + this.build.getUrl());
    }

    public String getDisplayName() {
        if (this.isIconDisplayed()) {
            return Messages.RequestDeleteBuildAction_DisplayName();
        }
        return null;
    }

    public String getIconFileName() {
        if (this.isIconDisplayed()) {
            return "/images/24x24/edit-delete.png";
        }
        return null;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public String getUrlName() {
        return "request-delete-build";
    }

    private boolean isIconDisplayed() {
        boolean isDisplayed = false;
        try {
            isDisplayed = !this.hasDeletePermission();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Impossible to know if the icon has to be displayed", e);
        }
        return isDisplayed;
    }

    private boolean hasDeletePermission() throws IOException, ServletException {
        return Functions.hasPermission((Permission)Run.DELETE);
    }
}

