/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.jenkins.plugin.requests.action;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class RequestMailSender
extends Builder {
    private final String itemName;
    private final String userName;
    private final String requestType;
    private final String projectURL;
    private String requestadminemail;
    private String requestmaildomain;
    private String requestemailserver;
    private static final Logger LOGGER = Logger.getLogger(RequestMailSender.class.getName());

    public RequestMailSender(String itemName, String userName, String requestType, String projectURL) {
        this.itemName = itemName;
        this.userName = userName;
        this.requestType = requestType;
        this.projectURL = projectURL;
    }

    private boolean checkAddress() {
        boolean checkStatus = false;
        if (this.requestadminemail != null && StringUtils.isNotBlank((String)this.requestadminemail)) {
            if (StringUtils.contains((String)this.requestadminemail, (char)'<')) {
                String[] tokens = this.requestadminemail.split("<");
                String tempStr = tokens[1];
                tokens = tempStr.split(">");
                this.requestadminemail = tokens[0];
            }
            checkStatus = true;
        }
        return checkStatus;
    }

    public String getProjectURL() {
        return this.projectURL;
    }

    public void executeEmail() throws MessagingException, UnknownHostException {
        if (!this.getDescriptor().isEnableEmails()) {
            LOGGER.log(Level.INFO, "[INFO] The Request email option is not enabled so an email will not be sent");
            return;
        }
        this.requestadminemail = this.getDescriptor().getRequestadminemail();
        this.requestmaildomain = this.getDescriptor().getRequestmaildomain();
        this.requestemailserver = this.getDescriptor().getRequestemailserver();
        boolean failedStatus = false;
        if (this.requestemailserver == null || this.requestemailserver.equals("")) {
            LOGGER.log(Level.WARNING, "[ERROR] The Requests email server value is missing so no email will not be sent");
            failedStatus = true;
        }
        if (this.requestmaildomain == null || this.requestmaildomain.equals("")) {
            LOGGER.log(Level.WARNING, "[ERROR] The Requests email domain is missing so mo email will not be sent");
            failedStatus = true;
        }
        if (this.requestadminemail == null || this.requestadminemail.equals("")) {
            LOGGER.log(Level.WARNING, "[ERROR] The Requests email address is missing so no email will not be sent");
            failedStatus = true;
        }
        if (!this.checkAddress()) {
            LOGGER.log(Level.WARNING, "[ERROR] The Requests email address is invalid so no email will not be sent");
            failedStatus = true;
        }
        if (failedStatus) {
            return;
        }
        MimeMessage mail = this.createMail(this.itemName, this.userName, this.requestType);
        if (mail != null) {
            Transport.send((Message)mail);
            LOGGER.log(Level.INFO, "[INFO] A Request email has been sent to " + this.requestadminemail + " from " + this.userName);
        }
    }

    private MimeMessage createMail(String itemName, String userName, String requestType) throws MessagingException, UnknownHostException {
        String jenkinsURL = this.getProjectURL();
        MimeMessage msg = this.createEmptyMail();
        StringBuffer buf = new StringBuffer();
        String[] jenkinsURLArray = null;
        try {
            if (msg != null) {
                String jenkinsHostName = InetAddress.getLocalHost().getHostName();
                if (Character.isLetter(jenkinsHostName.charAt(0))) {
                    String[] nameArray = jenkinsHostName.split("\\.");
                    jenkinsHostName = nameArray[0];
                    jenkinsHostName = jenkinsHostName.toUpperCase(Locale.ENGLISH);
                }
                if (this.projectURL.contains("/view/")) {
                    jenkinsURLArray = jenkinsURL.split("/view/");
                } else if (jenkinsURL.contains("/job/")) {
                    jenkinsURLArray = jenkinsURL.split("/job/");
                }
                String pendingRequestsLink = jenkinsURLArray[0] + "/plugin/requests/";
                msg.setSubject(String.format(jenkinsHostName + ": " + requestType + " Request has been submitted", new Object[0]));
                buf.append(".......................................................................................................................\n\n");
                buf.append(requestType + " request has been submitted for '" + itemName + "'.\n\n");
                buf.append("Pending Request Page:\n");
                buf.append(pendingRequestsLink + "\n\n\n");
                buf.append("Project Page:\n");
                buf.append(this.getProjectURL() + "\n");
                buf.append(".......................................................................................................................\n");
                msg.setText(buf.toString());
            }
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.SEVERE, "[ERROR] Exception: " + e.getMessage());
            return null;
        }
        return msg;
    }

    private MimeMessage createEmptyMail() throws MessagingException {
        String emailHost = this.getDescriptor().getRequestemailhost();
        if (emailHost == null || this.requestemailserver.equals("")) {
            emailHost = "localhost";
        }
        Properties properties = System.getProperties();
        properties.setProperty(this.requestemailserver, emailHost);
        Session session = Session.getDefaultInstance((Properties)properties);
        MimeMessage msg = null;
        try {
            msg = new MimeMessage(session);
            msg.setContent((Object)"", "text/html");
            msg.setFrom((Address)new InternetAddress(this.userName + this.requestmaildomain));
            msg.setSentDate(new Date());
            String[] emailAddresses = this.requestadminemail.split(",");
            int addressCount = emailAddresses.length;
            Address[] addresss_TO = new Address[addressCount];
            Address[] addresss_CC = new Address[1];
            if (this.requestadminemail.contains(",")) {
                for (int i = 0; i < addressCount; ++i) {
                    addresss_TO[i] = new InternetAddress(emailAddresses[i]);
                }
            } else {
                addresss_TO[0] = new InternetAddress(this.requestadminemail);
            }
            addresss_CC[0] = new InternetAddress(this.userName + this.requestmaildomain);
            msg.addRecipients(Message.RecipientType.TO, addresss_TO);
            msg.addRecipients(Message.RecipientType.CC, addresss_CC);
        }
        catch (MessagingException me) {
            LOGGER.log(Level.WARNING, "Unable to create email message! ", me.getMessage());
        }
        return msg;
    }

    public DescriptorEmailImpl getDescriptor() {
        return (DescriptorEmailImpl)super.getDescriptor();
    }

    @Extension
    public static class DescriptorEmailImpl
    extends BuildStepDescriptor<Builder> {
        private String requestadminemail;
        private String requestemailserver;
        private String requestmaildomain;
        private String requestemailhost;
        private String unlockuser;
        private Secret unlockpassword;
        private boolean enableDeleteJob;
        private boolean enableDeleteBuild;
        private boolean enableUnlockBuild;
        private boolean enableRenameJob;
        private boolean enableRenameFolder;
        private boolean enableDeleteFolder;
        private boolean enableEmails;

        @DataBoundConstructor
        public DescriptorEmailImpl() {
            super(RequestMailSender.class);
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json.getJSONObject("globalRequests"));
            this.save();
            return true;
        }

        public String getRequestemailserver() {
            return this.requestemailserver;
        }

        public String getRequestemailhost() {
            return this.requestemailhost;
        }

        public String getRequestmaildomain() {
            return this.requestmaildomain;
        }

        public String getRequestadminemail() {
            return this.requestadminemail;
        }

        public String getUnlockuser() {
            return this.unlockuser;
        }

        public Secret getUnlockpassword() {
            return this.unlockpassword;
        }

        public void setRequestemailserver(String requestemailserver) {
            this.requestemailserver = requestemailserver;
        }

        public void setRequestmaildomain(String requestmaildomain) {
            this.requestmaildomain = requestmaildomain;
        }

        public void setRequestadminemail(String requestadminemail) {
            this.requestadminemail = requestadminemail;
        }

        public void setRequestemailhost(String requestemailhost) {
            this.requestemailhost = requestemailhost;
        }

        public void setUnlockuser(String unlockuser) {
            this.unlockuser = unlockuser;
        }

        public void setUnlockpassword(Secret unlockpassword) {
            this.unlockpassword = unlockpassword;
        }

        public boolean getEnableDeleteJob() {
            return this.enableDeleteJob;
        }

        public boolean isEnableDeleteBuild() {
            return this.enableDeleteBuild;
        }

        public boolean isEnableUnlockBuild() {
            return this.enableUnlockBuild;
        }

        public boolean isEnableRenameJob() {
            return this.enableRenameJob;
        }

        public boolean isEnableRenameFolder() {
            return this.enableRenameFolder;
        }

        public boolean isEnableEmails() {
            return this.enableEmails;
        }

        public boolean isEnableDeleteFolder() {
            return this.enableDeleteFolder;
        }

        @DataBoundSetter
        public void setEnableDeleteJob(boolean enableDeleteJob) {
            this.enableDeleteJob = enableDeleteJob;
        }

        public void setEnableDeleteBuild(boolean enableDeleteBuild) {
            this.enableDeleteBuild = enableDeleteBuild;
        }

        public void setEnableUnlockBuild(boolean enableUnlockBuild) {
            this.enableUnlockBuild = enableUnlockBuild;
        }

        @DataBoundSetter
        public void setEnableRenameJob(boolean enableRenameJob) {
            this.enableRenameJob = enableRenameJob;
        }

        @DataBoundSetter
        public void setEnableRenameFolder(boolean enableRenameFolder) {
            this.enableRenameFolder = enableRenameFolder;
        }

        @DataBoundSetter
        public void setEnableDeleteFolder(boolean enableDeleteFolder) {
            this.enableDeleteFolder = enableDeleteFolder;
        }

        public void setEnableEmails(boolean enableEmails) {
            this.enableEmails = enableEmails;
        }

        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public String getDisplayName() {
            return "Requests";
        }

        @POST
        public FormValidation doTestEmail(@QueryParameter(value="testEmailAddress") String testEmailAddress) throws MessagingException, UnknownHostException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String emailHost = this.getRequestemailhost();
            String returnMessage = "Unable to create email message";
            if (emailHost == null || this.requestemailserver.equals("")) {
                emailHost = "localhost";
            }
            Properties properties = System.getProperties();
            properties.setProperty(this.requestemailserver, emailHost);
            Session session = Session.getDefaultInstance((Properties)properties);
            MimeMessage msg = null;
            try {
                msg = new MimeMessage(session);
                msg.setContent((Object)"", "text/html");
                msg.setFrom((Address)new InternetAddress(this.requestadminemail));
                msg.setSentDate(new Date());
                String[] emailAddresses = testEmailAddress.split(",");
                int addressCount = emailAddresses.length;
                Address[] addresss_TO = new Address[addressCount];
                if (testEmailAddress.contains(",")) {
                    for (int i = 0; i < addressCount; ++i) {
                        addresss_TO[i] = new InternetAddress(emailAddresses[i]);
                    }
                } else {
                    addresss_TO[0] = new InternetAddress(testEmailAddress);
                }
                msg.addRecipients(Message.RecipientType.TO, addresss_TO);
            }
            catch (MessagingException me) {
                LOGGER.log(Level.WARNING, "Unable to create email message! ", me.getMessage());
                returnMessage = "Unable to create email message";
                return FormValidation.error((String)returnMessage);
            }
            StringBuffer buf = new StringBuffer();
            msg.setSubject(String.format("Test Email - Jenkins Request Plugin", new Object[0]));
            buf.append(".......................................................................................................................\n");
            buf.append("This is a test email from the Jenkins Requests Plugin\n");
            buf.append(".......................................................................................................................\n");
            msg.setText(buf.toString());
            Transport.send((Message)msg);
            returnMessage = "Email sent successfully";
            return FormValidation.ok((String)returnMessage);
        }
    }
}

