/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.release.pipeline;

import hudson.AbortException;
import hudson.Extension;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.release.pipeline.ReleaseTriggerAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class ReleaseTriggerListener
extends RunListener<Run<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(ReleaseTriggerListener.class.getName());

    public void onStarted(Run<?, ?> run, TaskListener listener) {
        for (ReleaseTriggerAction.Trigger trigger : ReleaseTriggerAction.triggersFor(run)) {
            StepContext stepContext = trigger.context;
            if (stepContext != null && stepContext.isReady()) {
                LOGGER.log(Level.FINE, "started releasing {0} from #{1} in {2}", new Object[]{run, run.getQueueId(), stepContext});
                try {
                    TaskListener taskListener = (TaskListener)stepContext.get(TaskListener.class);
                    taskListener.getLogger().println("Starting releasing: " + ModelHyperlinkNote.encodeTo((String)("/" + run.getUrl()), (String)run.getFullDisplayName()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
                continue;
            }
            LOGGER.log(Level.FINE, "{0} unavailable in {1}", new Object[]{stepContext, run});
        }
    }

    public void onCompleted(Run<?, ?> run, @Nonnull TaskListener listener) {
        for (ReleaseTriggerAction.Trigger trigger : ReleaseTriggerAction.triggersFor(run)) {
            LOGGER.log(Level.FINE, "completing {0} for {1}", new Object[]{run, trigger.context});
            if (run.getResult() == Result.SUCCESS) {
                if (trigger.interruption == null) {
                    trigger.context.onSuccess((Object)new RunWrapper(run, false));
                    continue;
                }
                trigger.context.onFailure(trigger.interruption);
                continue;
            }
            trigger.context.onFailure((Throwable)new AbortException(run.getFullDisplayName() + " completed with status " + run.getResult()));
        }
        run.getActions().removeAll(run.getActions(ReleaseTriggerAction.class));
    }

    public void onDeleted(Run<?, ?> run) {
        for (ReleaseTriggerAction.Trigger trigger : ReleaseTriggerAction.triggersFor(run)) {
            trigger.context.onFailure((Throwable)new AbortException(run.getFullDisplayName() + " was deleted"));
        }
    }
}

