/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.google.common.base.Optional;
import hudson.Extension;
import hudson.model.Descriptor;
import java.io.PrintStream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.ticketing.TicketModification;

public class PerformTransitionModification
extends TicketModification {
    private String transitionName;
    private String comment;

    @DataBoundConstructor
    public PerformTransitionModification(String transitionName, String comment) {
        this.transitionName = transitionName;
        this.comment = comment;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public void apply(String ticketKey, JIRAAccessTool jira, StrSubstitutor varReplacer, PrintStream logger) {
        String transitionName = varReplacer.replace(this.transitionName);
        String comment = varReplacer.replace((String)Optional.fromNullable((Object)this.comment).or((Object)""));
        Issue issue = jira.getTicketByKey(ticketKey);
        int id = -1;
        for (Transition trans : jira.getAvailableTransitions(issue)) {
            if (!trans.getName().equalsIgnoreCase(transitionName)) continue;
            id = trans.getId();
        }
        if (id == -1) {
            throw new RuntimeException("The transition with the name \"" + transitionName + "\" is either non existent or not accessible for the Ticket " + ticketKey);
        }
        TransitionInput input = comment.isEmpty() ? new TransitionInput(id) : new TransitionInput(id, Comment.valueOf((String)comment));
        jira.performTransition(issue, input);
    }

    @Extension
    public static class DescribtorImpl
    extends Descriptor<TicketModification> {
        public String getDisplayName() {
            return "Perform Transition";
        }
    }
}

