/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import hudson.Extension;
import hudson.model.Descriptor;
import java.io.PrintStream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.IssueUpdateBuilder;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.ticketing.TicketModification;

public class AddCommentModification
extends TicketModification {
    private String commentBody;

    @DataBoundConstructor
    public AddCommentModification(String commentBody) {
        this.commentBody = commentBody;
    }

    public String getCommentBody() {
        return this.commentBody;
    }

    @Override
    public void apply(String ticketKey, JIRAAccessTool jira, final StrSubstitutor varReplacer, PrintStream logger) {
        if (this.commentBody != null && !this.commentBody.isEmpty()) {
            jira.updateTicket(ticketKey, new JIRAAccessTool.BuildingLambda<IssueUpdateBuilder>(){

                @Override
                public void build(IssueUpdateBuilder b) {
                    b.addComment(varReplacer.replace(AddCommentModification.this.commentBody));
                }
            });
        }
    }

    @Extension
    public static class DescribtorImpl
    extends Descriptor<TicketModification> {
        public String getDisplayName() {
            return "Add Comment";
        }
    }
}

