/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.influxdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateUtils;

public class InfluxContentParser {
    private static final Set<String> TRUE_BOOL_LITERALS = new HashSet<String>(Arrays.asList("t", "T", "true", "True", "TRUE"));
    private static final Set<String> FALSE_BOOL_LITERALS = new HashSet<String>(Arrays.asList("f", "F", "false", "False", "FALSE"));

    public static List<ContentLine> parse(String source) {
        String[] lines;
        ArrayList<ContentLine> results = new ArrayList<ContentLine>();
        for (String line : lines = source.split("\n")) {
            if ((line = InfluxContentParser.removeWhitespaces(line)).isEmpty()) continue;
            ContentLine content = new ContentLine();
            results.add(content);
            String[] spaceSepSegments = InfluxContentParser.splitConsideringQuotes(line);
            int index = 0;
            for (String segment : spaceSepSegments) {
                if (segment.isEmpty()) continue;
                switch (index) {
                    case 0: {
                        InfluxContentParser.parseKey(segment, content);
                        break;
                    }
                    case 1: {
                        InfluxContentParser.parseFields(segment, content);
                        break;
                    }
                    case 2: {
                        InfluxContentParser.parseTimestamp(segment, content);
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid line! : " + line);
                    }
                }
                ++index;
            }
        }
        return results;
    }

    private static String[] splitConsideringQuotes(String line) {
        int i;
        ArrayList<String> results = new ArrayList<String>();
        ArrayList<Integer> spacePositions = new ArrayList<Integer>();
        boolean wasPrevBackslash = false;
        int quoteCount = 0;
        for (i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ' && !wasPrevBackslash && quoteCount % 2 == 0) {
                spacePositions.add(i);
            }
            if (line.charAt(i) == '\"' && !wasPrevBackslash) {
                ++quoteCount;
            }
            wasPrevBackslash = line.charAt(i) == '\\';
        }
        for (i = -1; i < spacePositions.size(); ++i) {
            int end;
            int beg = i == -1 ? 0 : (Integer)spacePositions.get(i) + 1;
            if (beg == (end = i == spacePositions.size() - 1 ? line.length() : ((Integer)spacePositions.get(i + 1)).intValue())) continue;
            results.add(line.substring(beg, end));
        }
        return results.toArray(new String[0]);
    }

    private static void parseTimestamp(String segment, ContentLine content) {
        if (segment.contains("-")) {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            String[] data = segment.split("-");
            cal.set(Integer.parseInt(data[0]), Integer.parseInt(data[1]) - 1, Integer.parseInt(data[2]));
            DateUtils.truncate((Calendar)cal, (int)5);
            if (data.length > 3) {
                cal.set(11, Integer.parseInt(data[3]));
            }
            if (data.length > 4) {
                cal.set(12, Integer.parseInt(data[4]));
            }
            if (data.length > 5) {
                cal.set(13, Integer.parseInt(data[5]));
            }
            content.timestamp = cal.getTimeInMillis() * 1000L * 1000L;
        } else {
            content.timestamp = Long.parseLong(segment);
        }
    }

    private static void parseFields(String segment, ContentLine content) {
        String[] commaSegments;
        for (String keyValue : commaSegments = segment.split("(?<!\\\\),")) {
            String[] keyValueSplitted = keyValue.split("=");
            if (keyValueSplitted.length != 2) {
                throw new RuntimeException("invalid key value pair " + keyValue);
            }
            content.fields.put(keyValueSplitted[0], InfluxContentParser.parseFieldValue(keyValueSplitted[1]));
        }
    }

    private static Object parseFieldValue(String val) {
        if (val.startsWith("\"") && val.endsWith("\"")) {
            return InfluxContentParser.unescape(val.substring(1, val.length() - 1));
        }
        if (TRUE_BOOL_LITERALS.contains(val)) {
            return true;
        }
        if (FALSE_BOOL_LITERALS.contains(val)) {
            return false;
        }
        if (val.endsWith("i")) {
            return Integer.parseInt(val.substring(0, val.length() - 1));
        }
        return Double.parseDouble(val);
    }

    private static void parseKey(String segment, ContentLine content) {
        String[] commaSegments = segment.split("(?<!\\\\),");
        if (commaSegments.length < 2) {
            throw new RuntimeException("Tags are missing!");
        }
        content.measurementName = commaSegments[0];
        for (int i = 1; i < commaSegments.length; ++i) {
            String[] keyValuePair = commaSegments[i].split("(?<!\\\\)=");
            if (keyValuePair.length != 2) {
                throw new RuntimeException("invalid key value pair " + commaSegments[i]);
            }
            content.tags.put(InfluxContentParser.unescape(keyValuePair[0]), InfluxContentParser.unescape(keyValuePair[1]));
        }
    }

    private static String unescape(String str) {
        return str.replaceAll(Pattern.quote("\\ "), " ").replaceAll(Pattern.quote("\\,"), ",").replaceAll(Pattern.quote("\\="), "=").replaceAll(Pattern.quote("\\\""), "\"");
    }

    private static String removeWhitespaces(String src) {
        int leadingCount = 0;
        while (Character.isWhitespace(src.charAt(leadingCount))) {
            ++leadingCount;
        }
        int traillingCount = 0;
        while (Character.isWhitespace(src.charAt(src.length() - traillingCount - 1))) {
            ++traillingCount;
        }
        return src.substring(leadingCount, src.length() - traillingCount);
    }

    public static class ContentLine {
        private String measurementName;
        private Map<String, String> tags = new HashMap<String, String>();
        private Map<String, Object> fields = new HashMap<String, Object>();
        private Long timestamp;

        public String getMeasurementName() {
            return this.measurementName;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }

        public Map<String, Object> getFields() {
            return this.fields;
        }

        public Long getTimestamp() {
            return this.timestamp;
        }
    }
}

