/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.credentials;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@NameWith(value=NameProvider.class)
public class ConfluenceCredentials
extends BaseStandardCredentials
implements StandardCredentials {
    private static final long serialVersionUID = -565781284221184319L;
    @Nonnull
    private final String url;
    @Nonnull
    private final String urlUsername;
    @Nonnull
    private final String urlPassword;

    @DataBoundConstructor
    public ConfluenceCredentials(CredentialsScope scope, String id, String description, String url, String urlUsername, String urlPassword) {
        super(scope, id, description);
        this.url = url;
        this.urlUsername = urlUsername;
        this.urlPassword = urlPassword;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlUsername() {
        return this.urlUsername;
    }

    public String getUrlPassword() {
        return this.urlPassword;
    }

    public static ConfluenceCredentials getByID(String id) {
        return (ConfluenceCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(ConfluenceCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
    }

    public static class NameProvider
    extends CredentialsNameProvider<ConfluenceCredentials> {
        public String getName(ConfluenceCredentials c) {
            return c.getUrl() + " - " + c.getUrlUsername();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Confluence URL with credentials";
        }

        public FormValidation doCheckUrl(@QueryParameter String value, @QueryParameter String urlUsername, @QueryParameter String urlPassword) {
            if (value == null || value.isEmpty()) {
                return FormValidation.warning((String)"Please specify an URL");
            }
            if (urlUsername == null || urlUsername.isEmpty()) {
                return FormValidation.warning((String)"Please specify an username");
            }
            if (urlPassword == null || urlPassword.isEmpty()) {
                return FormValidation.warning((String)"Please specify an password");
            }
            String message = this.testConfluenceConnection(value, urlUsername, urlPassword);
            if (message == null) {
                return FormValidation.ok((String)"URL is accessible with the given credentials");
            }
            return FormValidation.warning((String)message);
        }

        private String testConfluenceConnection(String url, String user, String password) {
            URI uri;
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
            CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((org.apache.http.client.CredentialsProvider)credsProvider).build();
            try {
                uri = new URIBuilder(url + "/rest/api/space?spaceKey=rdsfsdfsdf").build();
            }
            catch (URISyntaxException e) {
                return "Malformed URL: " + e.getMessage();
            }
            if (uri.getScheme() == null || uri.getHost() == null) {
                return "Malformed URL";
            }
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
            authCache.put(host, (AuthScheme)basicAuth);
            HttpClientContext context = HttpClientContext.create();
            context.setCredentialsProvider((org.apache.http.client.CredentialsProvider)credsProvider);
            context.setAuthCache((AuthCache)authCache);
            HttpGet httpGet = new HttpGet(uri);
            try {
                CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet, (HttpContext)context);
                httpclient.close();
                if (response.getStatusLine().getStatusCode() == 200) {
                    return null;
                }
                return "Invalid Credentials or URL: " + response.getStatusLine();
            }
            catch (IOException e) {
                return "Could not access the REST API under the given url: " + e.getClass().getName() + " - " + e.getMessage();
            }
        }
    }
}

