/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Job;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.ticketing.TicketModification;

public class ModifyTicketsTemplate
extends AbstractDescribableImpl<ModifyTicketsTemplate> {
    private static final String REGEX_KEY_GROUP_NAME = "key";
    private String jqlFilter;
    private String commitRegEx;
    private String ticketSource;
    private List<TicketModification> modifications;

    @DataBoundConstructor
    public ModifyTicketsTemplate(String jqlFilter, String commitRegEx, String ticketSource, List<TicketModification> modifications) {
        this.jqlFilter = jqlFilter;
        this.commitRegEx = commitRegEx;
        this.ticketSource = ticketSource;
        this.modifications = modifications == null ? new ArrayList() : modifications;
    }

    public String getJqlFilter() {
        return this.jqlFilter;
    }

    public List<TicketModification> getModifications() {
        return this.modifications;
    }

    public String getCommitRegEx() {
        return this.commitRegEx;
    }

    public String getTicketSource() {
        return this.ticketSource;
    }

    public void applyModifications(JIRAAccessTool jira, StrSubstitutor varReplacer, PrintStream logger, AbstractBuild<?, ?> build) {
        HashSet<Issue> issuedToUpdate = new HashSet<Issue>();
        if ("JQL".equalsIgnoreCase(this.ticketSource)) {
            String jql = varReplacer.replace(this.jqlFilter);
            issuedToUpdate.addAll(jira.getTicketsByJQL(jql));
            logger.println("Updating " + issuedToUpdate.size() + " Tickets matching filter \"" + jql + "\"");
        } else if ("GHPullRequest".equalsIgnoreCase(this.ticketSource)) {
            String repoID = varReplacer.getVariableResolver().lookup("ghprbGhRepository");
            String pullReqIDStr = varReplacer.getVariableResolver().lookup("ghprbPullId");
            if (repoID == null || pullReqIDStr == null) {
                logger.println("${ghprbGhRepository} or ${ghprbPullId} has not been set, maybe this build wasn't triggered by the pull request builder plugin? Skipping ticket modifications...");
            } else {
                List<String> commitMsgs = this.extractCommitMessagesFromPullRequest(build, repoID, pullReqIDStr);
                Set<String> ticketKeys = this.extractTicketKeysFromCommitMessages(varReplacer, commitMsgs);
                String jql = this.buildJQLByTicketKeys(ticketKeys);
                issuedToUpdate.addAll(jira.getTicketsByJQL(jql));
            }
        }
        for (Issue ticket : issuedToUpdate) {
            for (TicketModification modification : this.modifications) {
                modification.apply(ticket.getKey(), jira, varReplacer, logger);
            }
        }
    }

    private String buildJQLByTicketKeys(Set<String> ticketKeys) {
        String jql = null;
        for (String key : ticketKeys) {
            jql = jql == null ? "" : jql + " OR ";
            jql = jql + "issueKey = \"" + key + "\"";
        }
        return jql;
    }

    private Set<String> extractTicketKeysFromCommitMessages(StrSubstitutor varReplacer, List<String> commitMsgs) {
        String regex = varReplacer.replace(this.commitRegEx);
        Pattern regexPattern = Pattern.compile(regex);
        HashSet<String> ticketKeys = new HashSet<String>();
        for (String msg : commitMsgs) {
            Matcher mat = regexPattern.matcher(msg);
            while (mat.find()) {
                String key = mat.group(REGEX_KEY_GROUP_NAME);
                if (key == null) continue;
                ticketKeys.add(key.toUpperCase());
            }
        }
        return ticketKeys;
    }

    private List<String> extractCommitMessagesFromPullRequest(AbstractBuild<?, ?> build, String repoID, String pullReqIDStr) {
        ArrayList<String> commitMsgs = new ArrayList<String>();
        int pullReqID = Integer.parseInt(pullReqIDStr);
        GHPullRequest pr = null;
        for (GitHubRepositoryName name : GitHubRepositoryNameContributor.parseAssociatedNames((Job)build.getProject())) {
            for (GHRepository repository : name.resolve()) {
                if (!repoID.equalsIgnoreCase(repository.getFullName())) continue;
                try {
                    pr = repository.getPullRequest(pullReqID);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (pr == null) {
            throw new RuntimeException("Couldn't find pull request #" + pullReqID + " in repo " + repoID + ", maybe it isn't accessible for the Jenkins user?");
        }
        for (GHPullRequestCommitDetail detail : pr.listCommits()) {
            GHPullRequestCommitDetail.Commit com = detail.getCommit();
            if (com.getMessage() == null) continue;
            commitMsgs.add(com.getMessage());
        }
        return commitMsgs;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ModifyTicketsTemplate> {
        public String getDisplayName() {
            return "Ticket Modification Filter";
        }
    }
}

