/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.twitter;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterPublisher
extends Builder {
    private String tokenCredentialsID;
    private String consumerCredentialsID;
    private String tweetText;

    @DataBoundConstructor
    public TwitterPublisher(String tokenCredentialsID, String consumerCredentialsID, String tweetText) {
        this.tokenCredentialsID = tokenCredentialsID;
        this.consumerCredentialsID = consumerCredentialsID;
        this.tweetText = tweetText;
    }

    public String getTokenCredentialsID() {
        return this.tokenCredentialsID;
    }

    public String getConsumerCredentialsID() {
        return this.consumerCredentialsID;
    }

    public String getTweetText() {
        return this.tweetText;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        StrSubstitutor varReplacer = this.getVariablesSubstitutor(build, listener);
        PrintStream logger = listener.getLogger();
        UsernamePasswordCredentials tokenCred = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM), (CredentialsMatcher)CredentialsMatchers.withId((String)this.tokenCredentialsID));
        UsernamePasswordCredentials consumerCred = (UsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM), (CredentialsMatcher)CredentialsMatchers.withId((String)this.consumerCredentialsID));
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setDebugEnabled(true).setOAuthConsumerKey(consumerCred.getUsername()).setOAuthConsumerSecret(consumerCred.getPassword().getPlainText()).setOAuthAccessToken(tokenCred.getUsername()).setOAuthAccessTokenSecret(tokenCred.getPassword().getPlainText());
        TwitterFactory tf = new TwitterFactory(cb.build());
        Twitter twitter = tf.getInstance();
        String text = varReplacer.replace(this.tweetText);
        try {
            for (Status stat : twitter.getUserTimeline()) {
                if (!stat.getText().equalsIgnoreCase(text)) continue;
                logger.println("Tweet is already present, therefore skipping publishing.");
                return true;
            }
            logger.println("Publishing tweet.");
            twitter.updateStatus(text);
        }
        catch (TwitterException e) {
            throw new RuntimeException("Could not itneract with twitter.", e);
        }
        return true;
    }

    protected StrSubstitutor getVariablesSubstitutor(AbstractBuild<?, ?> build, BuildListener lis) {
        EnvVars env;
        ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
        HashMap variables = new HashMap();
        try {
            env = build.getEnvironment((TaskListener)lis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry en : env.entrySet()) {
            variables.put(en.getKey(), en.getValue());
        }
        if (params != null) {
            for (ParameterValue val : params.getParameters()) {
                variables.put(val.getName(), val.getValue().toString());
            }
        }
        StrSubstitutor subs = new StrSubstitutor(variables);
        return subs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Twitter Publisher";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public ListBoxModel doFillTokenCredentialsIDItems(@AncestorInPath ItemGroup<?> context) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance()).hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, context, (Authentication)ACL.SYSTEM));
        }

        public ListBoxModel doFillConsumerCredentialsIDItems(@AncestorInPath ItemGroup<?> context) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance()).hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, context, (Authentication)ACL.SYSTEM));
        }
    }
}

