/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.util.ComboBoxModel;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import rocks.inspectit.releaseplugin.FieldMetadata;
import rocks.inspectit.releaseplugin.IssueUpdateBuilder;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.JIRAMetadataCache;
import rocks.inspectit.releaseplugin.ticketing.TicketModification;

public class ModifyArrayFieldModification
extends TicketModification {
    private String fieldHumanReadableName;
    private String modificationType;
    private String modificationValue;

    @DataBoundConstructor
    public ModifyArrayFieldModification(String fieldHumanReadableName, String modificationType, String modificationValue) {
        this.fieldHumanReadableName = fieldHumanReadableName;
        this.modificationValue = modificationValue;
        this.modificationType = modificationType == null || modificationType.isEmpty() ? "add" : modificationType;
    }

    public String getFieldHumanReadableName() {
        return this.fieldHumanReadableName;
    }

    public String getModificationType() {
        return this.modificationType;
    }

    public String getModificationValue() {
        return this.modificationValue;
    }

    @Override
    public void apply(String ticketKey, JIRAAccessTool jira, final StrSubstitutor varReplacer, PrintStream logger) {
        List<FieldMetadata> fields = JIRAMetadataCache.getSingleton().getFieldMetadata(jira.getJenkinsCredentialsId());
        String fieldName = varReplacer.replace(this.fieldHumanReadableName);
        FieldMetadata foundField = null;
        for (FieldMetadata field : fields) {
            if (!field.getHumanReadableName().equalsIgnoreCase(fieldName)) continue;
            foundField = field;
            break;
        }
        if (foundField == null) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" does not exist!");
        }
        if (!foundField.isModifiable()) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" is not modifiable!");
        }
        if (!foundField.isArray()) {
            throw new RuntimeException("Field with the name \"" + fieldName + "\" is not an array field, use the set-modifications!");
        }
        final FieldMetadata foundFieldFinal = foundField;
        jira.updateTicket(ticketKey, new JIRAAccessTool.BuildingLambda<IssueUpdateBuilder>(){

            @Override
            public void build(IssueUpdateBuilder b) {
                if (ModifyArrayFieldModification.this.modificationType.equals("add")) {
                    b.addFieldValue(foundFieldFinal.getInternalName(), foundFieldFinal.getElementType(), varReplacer.replace(ModifyArrayFieldModification.this.modificationValue));
                } else if (ModifyArrayFieldModification.this.modificationType.equals("remove")) {
                    b.removeFieldValue(foundFieldFinal.getInternalName(), foundFieldFinal.getElementType(), varReplacer.replace(ModifyArrayFieldModification.this.modificationValue));
                } else if (ModifyArrayFieldModification.this.modificationType.equals("replace")) {
                    b.setArrayField(foundFieldFinal.getInternalName(), foundFieldFinal.getElementType(), varReplacer.replace(ModifyArrayFieldModification.this.modificationValue));
                }
            }
        });
    }

    @Extension
    public static class DescribtorImpl
    extends Descriptor<TicketModification> {
        public String getDisplayName() {
            return "Add / Remove Field Value";
        }

        public ComboBoxModel doFillFieldHumanReadableNameItems(@RelativePath(value="../..") @QueryParameter String jiraCredentialsID) {
            ComboBoxModel result = new ComboBoxModel();
            for (FieldMetadata field : JIRAMetadataCache.getSingleton().getFieldMetadata(jiraCredentialsID)) {
                Set<String> allowedTypes = IssueUpdateBuilder.SUPPORTED_TYPES;
                if (!field.isArray() || !field.isModifiable() || !allowedTypes.contains(field.getElementType())) continue;
                result.add((Object)field.getHumanReadableName());
            }
            return result;
        }
    }
}

