/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.AbstractJIRAAction;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.credentials.JIRAProjectCredentials;
import rocks.inspectit.releaseplugin.ticketing.AddTicketTemplate;
import rocks.inspectit.releaseplugin.ticketing.ModifyTicketsTemplate;

public class JIRATicketEditor
extends AbstractJIRAAction {
    List<AddTicketTemplate> newTicketsTemplates;
    List<ModifyTicketsTemplate> modifyTicketsTemplates;

    @DataBoundConstructor
    public JIRATicketEditor(String jiraCredentialsID, List<AddTicketTemplate> newTicketsTemplates, List<ModifyTicketsTemplate> modifyTicketsTemplates) {
        super(jiraCredentialsID);
        this.newTicketsTemplates = newTicketsTemplates == null ? new ArrayList() : newTicketsTemplates;
        this.modifyTicketsTemplates = modifyTicketsTemplates == null ? new ArrayList() : modifyTicketsTemplates;
    }

    public List<AddTicketTemplate> getNewTicketsTemplates() {
        return this.newTicketsTemplates;
    }

    public List<ModifyTicketsTemplate> getModifyTicketsTemplates() {
        return this.modifyTicketsTemplates;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        StrSubstitutor varReplacer = this.getVariablesSubstitutor(build, listener);
        PrintStream logger = listener.getLogger();
        JIRAProjectCredentials cred = this.getJiraCredentials();
        JIRAAccessTool jira = new JIRAAccessTool(cred.getUrl(), cred.getUrlUsername(), cred.getUrlPassword(), null, cred.getProjectKey(), this.getJiraCredentialsID());
        for (ModifyTicketsTemplate modifyTicketsTemplate : this.modifyTicketsTemplates) {
            modifyTicketsTemplate.applyModifications(jira, varReplacer, logger, build);
        }
        for (AddTicketTemplate addTicketTemplate : this.newTicketsTemplates) {
            addTicketTemplate.publishTicket(jira, varReplacer, logger, build.getEnvironment((TaskListener)listener));
            varReplacer = this.getVariablesSubstitutor(build, listener);
        }
        jira.destroy();
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractJIRAAction.DescriptorImpl {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "JIRA Ticket Editor";
        }
    }
}

