/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.ticketing;

import com.atlassian.jira.rest.client.api.domain.BasicIssueType;
import com.atlassian.jira.rest.client.api.domain.BasicPriority;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import hudson.EnvVars;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ComboBoxModel;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import rocks.inspectit.releaseplugin.IssueUpdateBuilder;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.JIRAMetadataCache;
import rocks.inspectit.releaseplugin.ticketing.AddTicketField;

public class AddTicketTemplate
extends AbstractDescribableImpl<AddTicketTemplate> {
    private boolean performDuplicateCheck;
    private String parentJQL;
    private String title;
    private String type;
    private String priority;
    private String description;
    private String envVarName;
    private List<AddTicketField> fieldValues;

    @DataBoundConstructor
    public AddTicketTemplate(boolean performDuplicateCheck, String parentJQL, String title, String type, String priority, String description, String envVarName, List<AddTicketField> fieldValues) {
        this.performDuplicateCheck = performDuplicateCheck;
        this.parentJQL = parentJQL;
        this.title = title;
        this.type = type;
        this.priority = priority;
        this.description = description;
        this.envVarName = envVarName;
        this.fieldValues = fieldValues == null ? new ArrayList() : fieldValues;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getPerformDuplicateCheck() {
        return this.performDuplicateCheck;
    }

    public String getParentJQL() {
        return this.parentJQL;
    }

    public String getEnvVarName() {
        return this.envVarName;
    }

    public List<AddTicketField> getFieldValues() {
        return this.fieldValues;
    }

    public void publishTicket(final JIRAAccessTool jira, final StrSubstitutor varReplacer, final PrintStream logger, EnvVars vars) {
        String realEnvVar;
        final String title = varReplacer.replace(this.title);
        String type = varReplacer.replace(this.type);
        String priority = varReplacer.replace(this.priority);
        final String description = varReplacer.replace(this.description);
        String parentJQL = varReplacer.replace(this.parentJQL);
        IssueType issueType = jira.getIssueTypeByName(type);
        final BasicPriority issuePriority = jira.getIssuePriorityByName(priority);
        String parentKey = null;
        if (issueType.isSubtask()) {
            List<Issue> result = jira.getTicketsByJQL(parentJQL);
            if (result.size() != 1) {
                throw new RuntimeException("Invalid number of tickets (" + result.size() + ") matching parent JQL '" + parentJQL + "'");
            }
            parentKey = result.get(0).getKey();
        }
        final String finalParentKey = parentKey;
        if (this.performDuplicateCheck) {
            String jql = "summary ~ \"" + title + "\"";
            if (finalParentKey != null) {
                jql = jql + " AND parent = " + finalParentKey;
            }
            boolean alreadyPresent = false;
            for (Issue is : jira.getTicketsByJQL(jql)) {
                if (!is.getSummary().equalsIgnoreCase(title)) continue;
                alreadyPresent = true;
                break;
            }
            if (alreadyPresent) {
                logger.println("Skipping Ticket \"" + title + "\", as it is already present.");
                return;
            }
        }
        logger.println("Creating Ticket \"" + title + "\".");
        String ticketKey = jira.addTicket(new JIRAAccessTool.BuildingLambda<IssueInputBuilder>(){

            @Override
            public void build(IssueInputBuilder b) {
                b.setSummary(title);
                b.setDescription(description);
                if (issuePriority != null) {
                    b.setPriority(issuePriority);
                }
                if (finalParentKey != null) {
                    b.setFieldValue("parent", ComplexIssueInputFieldValue.with((String)"key", (Object)finalParentKey));
                }
            }
        }, (BasicIssueType)issueType).getKey();
        if (!this.fieldValues.isEmpty()) {
            jira.updateTicket(ticketKey, new JIRAAccessTool.BuildingLambda<IssueUpdateBuilder>(){

                @Override
                public void build(IssueUpdateBuilder builder) {
                    for (AddTicketField addOp : AddTicketTemplate.this.fieldValues) {
                        addOp.apply(builder, jira, varReplacer, logger);
                    }
                }
            });
        }
        if (!(realEnvVar = varReplacer.replace(this.envVarName == null ? "" : this.envVarName)).isEmpty()) {
            logger.print("Setting var " + realEnvVar);
            vars.put(realEnvVar, ticketKey);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AddTicketTemplate> {
        public String getDisplayName() {
            return "New JIRA Ticket Template";
        }

        public ComboBoxModel doFillTypeItems(@RelativePath(value="..") @QueryParameter String jiraCredentialsID) {
            ComboBoxModel result = new ComboBoxModel();
            result.addAll(JIRAMetadataCache.getSingleton().getAvailableIssueTypes(jiraCredentialsID));
            return result;
        }

        public ComboBoxModel doFillPriorityItems(@RelativePath(value="..") @QueryParameter String jiraCredentialsID) {
            ComboBoxModel result = new ComboBoxModel();
            result.addAll(JIRAMetadataCache.getSingleton().getAvailableIssuePriorities(jiraCredentialsID));
            return result;
        }
    }
}

