/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.releasenotes;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.cloudbees.jenkins.GitHubRepositoryNameContributor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.text.StrSubstitutor;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.credentials.JIRAProjectCredentials;
import rocks.inspectit.releaseplugin.releasenotes.GHSerializableConnection;

public class GithubReleasePublisher
extends Notifier {
    private String jiraCredentialsID;
    private String jqlFilter;
    private String repoName;
    private String releaseTag;
    private String releaseName;
    private boolean isPrerelease;
    private String artifactPatterns;

    @DataBoundConstructor
    public GithubReleasePublisher(String jiraCredentialsID, String jqlFilter, String repoName, String releaseTag, String releaseName, boolean isPrerelease, String artifactPatterns) {
        this.jiraCredentialsID = jiraCredentialsID;
        this.jqlFilter = jqlFilter;
        this.repoName = repoName;
        this.releaseTag = releaseTag;
        this.isPrerelease = isPrerelease;
        this.artifactPatterns = artifactPatterns;
        this.releaseName = releaseName;
    }

    public String getJqlFilter() {
        return this.jqlFilter;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public String getReleaseTag() {
        return this.releaseTag;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public boolean getIsPrerelease() {
        return this.isPrerelease;
    }

    public String getArtifactPatterns() {
        return this.artifactPatterns;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        StrSubstitutor varReplacer = this.getVariablesSubstitutor(build, listener);
        PrintStream logger = listener.getLogger();
        JIRAProjectCredentials jiraCred = this.getJiraCredentials();
        JIRAAccessTool jira = new JIRAAccessTool(jiraCred.getUrl(), jiraCred.getUrlUsername(), jiraCred.getUrlPassword(), null, jiraCred.getProjectKey(), this.getJiraCredentialsID());
        String jqlFilter = varReplacer.replace(this.jqlFilter);
        String repoName = varReplacer.replace(this.repoName);
        String artifactPatterns = varReplacer.replace(this.artifactPatterns);
        String releaseTag = varReplacer.replace(this.releaseTag);
        String releaseName = varReplacer.replace(this.releaseName);
        GHRepository repo = null;
        GitHubRepositoryName repositoryName = null;
        for (GitHubRepositoryName name : GitHubRepositoryNameContributor.parseAssociatedNames((Job)build.getProject())) {
            for (GHRepository repository : name.resolve()) {
                if (!repoName.equalsIgnoreCase(repository.getFullName())) continue;
                repositoryName = name;
                repo = repository;
            }
        }
        if (repo == null) {
            throw new RuntimeException("Repository with name " + repoName + " was not found! did you specify the orrect credentials under the git section?");
        }
        List<Issue> tickets = jira.getTicketsByJQL(jqlFilter);
        logger.println("Found " + tickets.size() + " tickets assigned to GitHub release " + releaseName + ".");
        String pageHTML = "";
        if (!tickets.isEmpty()) {
            pageHTML = jira.buildReleaseNotesHTML(tickets);
        }
        GHReleaseBuilder releaseBuilder = repo.createRelease(releaseTag);
        releaseBuilder.name(releaseName);
        releaseBuilder.prerelease(this.isPrerelease);
        releaseBuilder.body(pageHTML);
        GHSerializableConnection ghConnection = new GHSerializableConnection(repositoryName);
        GHRelease rel = releaseBuilder.create();
        for (FilePath path : build.getWorkspace().list(artifactPatterns)) {
            String assetName = path.getName();
            boolean uploadSuccessful = false;
            int numberOfTrialsLeft = 3;
            do {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --numberOfTrialsLeft;
                    logger.println("Uploading asset to release: " + assetName);
                    path.act((FilePath.FileCallable)new GHReleaseFileCallable(ghConnection, releaseName));
                    uploadSuccessful = true;
                }
                catch (Exception e) {
                    logger.println("Asset upload failed (" + e.getClass().getName() + ": " + e.getMessage() + ")");
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (GHAsset asset : rel.getAssets()) {
                        if (!asset.getName().equals(assetName)) continue;
                        logger.println("Deleting invalid asset from release (ID: " + asset.getId() + ").");
                        try {
                            asset.delete();
                        }
                        catch (Exception e2) {
                            logger.println("Could not delete asset, continuing anyway.. (" + e2.getClass().getName() + ": " + e2.getMessage() + ")");
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (numberOfTrialsLeft > 0) {
                        logger.println("Retrying upload " + numberOfTrialsLeft + " times.");
                        continue;
                    }
                    logger.println("Aborting build due to upload failure.");
                    throw e;
                }
            } while (!uploadSuccessful && numberOfTrialsLeft > 0);
        }
        jira.destroy();
        return true;
    }

    public String getJiraCredentialsID() {
        return this.jiraCredentialsID;
    }

    public JIRAProjectCredentials getJiraCredentials() {
        return JIRAProjectCredentials.getByID(this.jiraCredentialsID);
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return null;
    }

    protected StrSubstitutor getVariablesSubstitutor(AbstractBuild<?, ?> build, BuildListener lis) {
        EnvVars env;
        ParametersAction params = (ParametersAction)build.getAction(ParametersAction.class);
        HashMap variables = new HashMap();
        try {
            env = build.getEnvironment((TaskListener)lis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry en : env.entrySet()) {
            variables.put(en.getKey(), en.getValue());
        }
        if (params != null) {
            for (ParameterValue val : params.getParameters()) {
                variables.put(val.getName(), val.getValue().toString());
            }
        }
        StrSubstitutor subs = new StrSubstitutor(variables);
        return subs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Publish A Release on GitHub";
        }

        public ListBoxModel doFillJiraCredentialsIDItems(@AncestorInPath ItemGroup<?> context) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.getInstance()).hasPermission(Computer.CONFIGURE)) {
                return new ListBoxModel();
            }
            return new StandardListBoxModel().withAll((Iterable)CredentialsProvider.lookupCredentials(JIRAProjectCredentials.class, context, (Authentication)ACL.SYSTEM));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }

    private static final class GHReleaseFileCallable
    implements FilePath.FileCallable<Void> {
        GHSerializableConnection ghConnection;
        private final String releaseName;
        private static final long serialVersionUID = 1L;

        private GHReleaseFileCallable(GHSerializableConnection ghConnection, String releaseName) {
            this.releaseName = releaseName;
            this.ghConnection = ghConnection;
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            GHRelease releaseToUploadTo = null;
            GitHub github = this.ghConnection.connect();
            GHRepository repo = github.getRepository(this.ghConnection.getTotalRepositoryName());
            PagedIterable listReleases = repo.listReleases();
            for (GHRelease release : listReleases) {
                if (!release.getName().equals(this.releaseName)) continue;
                releaseToUploadTo = release;
            }
            String mimeType = Files.probeContentType(f.toPath());
            if (mimeType == null) {
                mimeType = "text/plain";
            }
            releaseToUploadTo.uploadAsset(f, mimeType);
            return null;
        }
    }
}

