/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin.releasenotes;

import com.atlassian.jira.rest.client.api.domain.Issue;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import rocks.inspectit.releaseplugin.AbstractJIRAConfluenceAction;
import rocks.inspectit.releaseplugin.ConfluenceAccessTool;
import rocks.inspectit.releaseplugin.JIRAAccessTool;
import rocks.inspectit.releaseplugin.credentials.ConfluenceCredentials;
import rocks.inspectit.releaseplugin.credentials.JIRAProjectCredentials;

public class ConfluenceReleaseNotesPublisher
extends AbstractJIRAConfluenceAction {
    private String spaceKey;
    private String jqlFilter;
    private String pageTitle;
    private String parentPageTitle;

    @DataBoundConstructor
    public ConfluenceReleaseNotesPublisher(String jiraCredentialsID, String confluenceCredentialsID, String spaceKey, String jqlFilter, String pageTitle, String parentPageTitle) {
        super(jiraCredentialsID, confluenceCredentialsID);
        this.spaceKey = spaceKey;
        this.jqlFilter = jqlFilter;
        this.pageTitle = pageTitle;
        this.parentPageTitle = parentPageTitle;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getJqlFilter() {
        return this.jqlFilter;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getParentPageTitle() {
        return this.parentPageTitle;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        StrSubstitutor varReplacer = this.getVariablesSubstitutor(build, listener);
        PrintStream logger = listener.getLogger();
        JIRAProjectCredentials jiraCred = this.getJiraCredentials();
        ConfluenceCredentials confCred = this.getConfluenceCredentials();
        JIRAAccessTool jira = new JIRAAccessTool(jiraCred.getUrl(), jiraCred.getUrlUsername(), jiraCred.getUrlPassword(), null, jiraCred.getProjectKey(), this.getJiraCredentialsID());
        ConfluenceAccessTool confluence = new ConfluenceAccessTool(confCred.getUrl(), confCred.getUrlUsername(), confCred.getUrlPassword(), null);
        String jqlFilter = varReplacer.replace(this.jqlFilter);
        String spaceKey = varReplacer.replace(this.spaceKey);
        String pageTitle = varReplacer.replace(this.pageTitle);
        String parentPageTitle = varReplacer.replace(this.parentPageTitle);
        List<Issue> tickets = jira.getTicketsByJQL(jqlFilter);
        logger.println("Publishing " + tickets.size() + " tickets on page '" + pageTitle + "' in space '" + spaceKey + "' on confluence.");
        String pageHTML = jira.buildReleaseNotesHTML(tickets);
        Long parentPageID = null;
        if (!parentPageTitle.isEmpty()) {
            List<Long> results = confluence.getPageIDByTitle(parentPageTitle, spaceKey);
            if (results.size() == 0) {
                throw new RuntimeException("No page with title '" + parentPageTitle + "' found!");
            }
            if (results.size() > 1) {
                throw new RuntimeException("Multiple pages with title '" + parentPageTitle + "' found!");
            }
            parentPageID = results.get(0);
        }
        confluence.createPage(pageTitle, pageHTML, spaceKey, parentPageID);
        confluence.destroy();
        jira.destroy();
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractJIRAConfluenceAction.DescriptorImpl {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Publish Release Notes on Confluence";
        }
    }
}

