/*
 * Decompiled with CFR 0.152.
 */
package rocks.inspectit.releaseplugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IssueUpdateBuilder {
    private static final String VERSION_FIELD = "versions";
    private static final String COMMENT_FIELD = "comment";
    public static final Set<String> SUPPORTED_TYPES = new HashSet<String>(Arrays.asList("any", "number", "string", "version"));
    private JsonObject updateOperations = new JsonObject();

    public JsonElement getRequestData() {
        JsonObject data = new JsonObject();
        data.add("update", (JsonElement)this.updateOperations);
        return data;
    }

    private JsonArray getFieldUpdates(String fieldName) {
        JsonElement elem = this.updateOperations.get(fieldName);
        if (elem == null) {
            elem = new JsonArray();
            this.updateOperations.add(fieldName, elem);
        }
        return elem.getAsJsonArray();
    }

    public void addAffectedVersion(String versionName) {
        this.getFieldUpdates(VERSION_FIELD).add((JsonElement)this.buildAdd((JsonElement)this.builNameReference(versionName)));
    }

    public void addComment(String body) {
        this.getFieldUpdates(COMMENT_FIELD).add((JsonElement)this.buildAdd(this.buildComment(body)));
    }

    private JsonElement buildComment(String body) {
        JsonObject comment = new JsonObject();
        comment.addProperty("body", body);
        return comment;
    }

    public void setFieldValue(String fieldName, String fieldType, String value) {
        JsonElement newValue = this.packageValue(fieldType, value);
        this.getFieldUpdates(fieldName).add((JsonElement)this.buildSet(newValue));
    }

    public void setArrayField(String fieldName, String fieldType, String ... values) {
        JsonArray arr = new JsonArray();
        for (String value : values) {
            arr.add(this.packageValue(fieldType, value));
        }
        this.getFieldUpdates(fieldName).add((JsonElement)this.buildSet((JsonElement)arr));
    }

    private JsonElement packageValue(String fieldType, String value) {
        Object newValue = fieldType.equals("version") ? this.builNameReference(value) : new JsonPrimitive(value);
        return newValue;
    }

    public void addFieldValue(String fieldName, String fieldType, String value) {
        JsonElement newValue = this.packageValue(fieldType, value);
        this.getFieldUpdates(fieldName).add((JsonElement)this.buildAdd(newValue));
    }

    public void removeFieldValue(String fieldName, String fieldType, String value) {
        JsonElement newValue = this.packageValue(fieldType, value);
        this.getFieldUpdates(fieldName).add((JsonElement)this.buildRemove(newValue));
    }

    public void removeAffectedVersion(String versionName) {
        this.getFieldUpdates(VERSION_FIELD).add((JsonElement)this.buildRemove((JsonElement)this.builNameReference(versionName)));
    }

    private JsonObject buildAdd(JsonElement elementToAdd) {
        JsonObject add = new JsonObject();
        add.add("add", elementToAdd);
        return add;
    }

    private JsonObject buildRemove(JsonElement elementToRemove) {
        JsonObject add = new JsonObject();
        add.add("remove", elementToRemove);
        return add;
    }

    private JsonObject buildSet(JsonElement elementToSet) {
        JsonObject add = new JsonObject();
        add.add("set", elementToSet);
        return add;
    }

    private JsonObject builNameReference(String name) {
        JsonObject reference = new JsonObject();
        reference.addProperty("name", name);
        return reference;
    }
}

