/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.random_string_parameter;

import hudson.AbortException;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.StringParameterValue;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomStringParameterValue
extends StringParameterValue {
    private String regex = "[a-zA-Z0-9_,-]{8,}";

    @DataBoundConstructor
    public RandomStringParameterValue(String name, String value) {
        this(name, value, null);
    }

    public RandomStringParameterValue(String name, String value, String description) {
        super(name, value, description);
    }

    public String getValue() {
        return this.value;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (!Pattern.matches(this.regex, this.value)) {
            return new BuildWrapper(){

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    throw new AbortException("Invalid value for parameter [" + RandomStringParameterValue.this.getName() + "] specified: " + RandomStringParameterValue.this.value);
                }
            };
        }
        return null;
    }

    public int hashCode() {
        int prime = 71;
        int result = super.hashCode();
        result = 71 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (RandomStringParameterValue.class != obj.getClass()) {
            return false;
        }
        RandomStringParameterValue other = (RandomStringParameterValue)((Object)obj);
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "(RandomStringParameterValue) " + this.getName() + "='" + this.value + "'";
    }
}

