/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.random_string_parameter;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.random_string_parameter.RandomStringParameterValue;
import hudson.util.FormValidation;
import java.util.Random;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class RandomStringParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 1L;
    private String failedValidationMessage;
    static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static Random rnd = new Random();

    @DataBoundConstructor
    public RandomStringParameterDefinition(String name, String failedValidationMessage, String description) {
        super(name, description);
        this.failedValidationMessage = failedValidationMessage;
    }

    public RandomStringParameterDefinition(String name, String failedValidationMessage) {
        this(name, failedValidationMessage, null);
    }

    public String getFailedValidationMessage() {
        return this.failedValidationMessage;
    }

    public String getDefaultValue() {
        return this.createRandomString();
    }

    public String getRootUrl() {
        return Hudson.getInstance().getRootUrl();
    }

    public String createRandomString() {
        StringBuilder sb = new StringBuilder(12);
        for (int i = 0; i < 12; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }

    public RandomStringParameterValue getDefaultParameterValue() {
        RandomStringParameterValue v = new RandomStringParameterValue(this.getName(), this.createRandomString(), this.getDescription());
        return v;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        RandomStringParameterValue value = (RandomStringParameterValue)((Object)req.bindJSON(RandomStringParameterValue.class, jo));
        value.setDescription(this.getDescription());
        return value;
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null || value.length < 1) {
            return this.getDefaultParameterValue();
        }
        return new RandomStringParameterValue(this.getName(), value[0], this.getDescription());
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        private String regex = "[a-zA-Z0-9_,-]{8,}";

        public String getDisplayName() {
            return "Random String Parameter";
        }

        public String getHelpFile() {
            return "/plugin/random-string-parameter/help.html";
        }

        public FormValidation doValidate(@QueryParameter(value="failedValidationMessage") String failedValidationMessage, @QueryParameter(value="value") String value) {
            try {
                if (Pattern.matches(this.regex, value)) {
                    return FormValidation.ok();
                }
                return failedValidationMessage == null || "".equals(failedValidationMessage) ? FormValidation.error((String)("Value entered does not match regular expression: " + this.regex)) : FormValidation.error((String)failedValidationMessage);
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)("Invalid regular expression [" + this.regex + "]: " + pse.getDescription()));
            }
        }
    }
}

