/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Functions;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.ClaimWrapper;
import hudson.model.IViewEntry;
import hudson.model.Job;
import hudson.model.RadiatorUtil;
import hudson.model.RadiatorView;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.ViewEntryColors;
import hudson.tasks.test.AbstractTestResultAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class JobViewEntry
implements IViewEntry {
    private static final String NOT_CLAIMED = "Not Claimed.";
    private final RadiatorView radiatorView;
    private Job<?, ?> job;
    private String backgroundColor;
    private String color;
    private Boolean broken = false;
    private Boolean building = false;
    private boolean stable = false;
    private boolean notBuilt = false;

    public JobViewEntry(RadiatorView radiatorView, Job<?, ?> job) {
        this.radiatorView = radiatorView;
        this.job = job;
        this.findStatus();
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    @Override
    public String getName() {
        return this.job.getFullName();
    }

    @Override
    public Boolean getQueued() {
        return this.job.isInQueue();
    }

    public Integer getQueueNumber() {
        return this.radiatorView.placeInQueue.get(this.job.getQueueItem());
    }

    @Override
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getStatus() {
        if (this.isNotBuilt()) {
            return "never built";
        }
        if (this.getStable()) {
            return "successful";
        }
        if (this.isCompletelyClaimed()) {
            return "claimed";
        }
        if (this.getBroken().booleanValue()) {
            return "failing";
        }
        return "unstable";
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public Boolean getBroken() {
        return this.broken;
    }

    @Override
    public Boolean getBuilding() {
        return this.building;
    }

    @Override
    public String getUrl() {
        return this.job.getUrl();
    }

    public String getLastBuildUrl() {
        Run lastBuild = this.job.getLastBuild();
        if (lastBuild == null) {
            return this.job.getUrl();
        }
        return lastBuild.getUrl();
    }

    public List<Run<?, ?>> getBuildsInProgress() {
        ArrayList runs = new ArrayList();
        Run run = this.job.getLastBuild();
        if (run != null) {
            if (run.isBuilding()) {
                runs.add(run);
            }
            for (Run prev = run.getPreviousBuildInProgress(); prev != null; prev = prev.getPreviousBuildInProgress()) {
                runs.add(prev);
            }
        }
        return runs;
    }

    @Override
    public int getTestCount() {
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            return tests != null ? tests.getTotalCount() : 0;
        }
        return 0;
    }

    @Override
    public int getFailCount() {
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            return tests != null ? tests.getFailCount() : 0;
        }
        return 0;
    }

    @Override
    public int getSuccessCount() {
        return this.getTestCount() - this.getFailCount();
    }

    @Override
    public String getDiff() {
        Run<?, ?> previous;
        Run run = this.job.getLastSuccessfulBuild();
        if (run != null && (previous = this.getLastSuccessfulFrom(run)) != null) {
            AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
            AbstractTestResultAction prevTests = (AbstractTestResultAction)previous.getAction(AbstractTestResultAction.class);
            if (tests != null && prevTests != null) {
                int prevSuccess;
                int currentSuccess = tests.getTotalCount() - tests.getFailCount();
                int diff = currentSuccess - (prevSuccess = prevTests.getTotalCount() - prevTests.getFailCount());
                if (diff != 0) {
                    return Functions.getDiffString((int)diff);
                }
                return "";
            }
        }
        return "";
    }

    private Run<?, ?> getLastSuccessfulFrom(Run<?, ?> run) {
        Run previousBuild = run.getPreviousBuild();
        while (this.hasPreviousBuildBuildingOrWithResultWorseThanUnstable(previousBuild)) {
            previousBuild = previousBuild.getPreviousBuild();
        }
        return previousBuild;
    }

    private boolean hasPreviousBuildBuildingOrWithResultWorseThanUnstable(Run<?, ?> previousBuild) {
        if (previousBuild != null) {
            if (previousBuild.isBuilding()) {
                return true;
            }
            Result result = previousBuild.getResult();
            if (result == null) {
                return true;
            }
            if (result.isWorseThan(Result.UNSTABLE)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<String> getCulprits() {
        Run run = this.job.getLastBuild();
        HashSet<String> culprits = new HashSet<String>();
        while (run != null) {
            if (run instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                Iterator it = build.getCulprits().iterator();
                while (it.hasNext()) {
                    culprits.add(((User)it.next()).getFullName());
                }
            }
            if ((run = run.getPreviousBuild()) == null || !Result.SUCCESS.equals(run.getResult())) continue;
            run = null;
        }
        return culprits;
    }

    @Override
    public String getCulprit() {
        Collection<String> culprits = this.getCulprits();
        String culprit = " - ";
        if (!culprits.isEmpty()) {
            culprit = StringUtils.join(culprits, (String)", ");
        }
        return culprit;
    }

    @Override
    public String getDiffColor() {
        String diff = this.getDiff().trim();
        if (diff.length() > 0 && !Functions.getDiffString((int)0).equals(diff)) {
            if (diff.startsWith("-")) {
                return "#FF0000";
            }
            return "#00FF00";
        }
        return "#FFFFFF";
    }

    @Override
    public String getSuccessPercentage() {
        if (this.getTestCount() > 0) {
            Double perc = (double)this.getSuccessCount() / ((double)this.getTestCount() * 1.0);
            return NumberFormat.getPercentInstance().format(perc);
        }
        return "";
    }

    private void findStatus() {
        Result result = RadiatorUtil.getLastFinishedResult(this.job);
        if (result.ordinal == Result.NOT_BUILT.ordinal) {
            this.backgroundColor = this.getColors().getOtherBG();
            this.color = this.getColors().getOtherFG();
            this.notBuilt = true;
        } else if (result.ordinal == Result.SUCCESS.ordinal) {
            this.backgroundColor = this.getColors().getOkBG();
            this.color = this.getColors().getOkFG();
            this.stable = true;
        } else if (result.ordinal == Result.UNSTABLE.ordinal) {
            this.backgroundColor = this.getColors().getFailedBG();
            this.color = this.getColors().getFailedFG();
        } else {
            this.backgroundColor = this.getColors().getBrokenBG();
            this.color = this.getColors().getBrokenFG();
            this.broken = true;
        }
        switch (this.job.getIconColor()) {
            case BLUE_ANIME: 
            case YELLOW_ANIME: 
            case RED_ANIME: 
            case GREY_ANIME: 
            case DISABLED_ANIME: {
                this.building = true;
                break;
            }
            default: {
                this.building = false;
            }
        }
    }

    private ViewEntryColors getColors() {
        return this.radiatorView.getColors();
    }

    @Override
    public String getLastCompletedBuild() {
        Run build = this.job.getLastCompletedBuild();
        if (build != null) {
            return build.getTimestampString() + " (" + build.getDurationString() + ")";
        }
        return null;
    }

    @Override
    public String getLastStableBuild() {
        Run build = this.job.getLastStableBuild();
        if (build != null) {
            return build.getTimestampString() + " (in " + build.getDurationString() + ")";
        }
        return null;
    }

    @Override
    public boolean getStable() {
        return this.stable;
    }

    @Override
    public boolean isNotBuilt() {
        return this.notBuilt;
    }

    @Override
    public String getClaim() {
        String claim;
        if (Jenkins.getActiveInstance().getPlugin("claim") == null) {
            return null;
        }
        Run<?, ?> lastBuild = this.getLastCompletedRun();
        if (lastBuild == null) {
            return null;
        }
        if (lastBuild instanceof MatrixBuild) {
            MatrixBuild matrixBuild = (MatrixBuild)lastBuild;
            claim = this.buildMatrixClaimString(matrixBuild, true);
        } else {
            ClaimWrapper claimWrapper = ClaimWrapper.builder(lastBuild);
            if (claimWrapper != null && claimWrapper.isClaimed()) {
                StringBuilder sb = new StringBuilder();
                if (claimWrapper.getReason() != null) {
                    sb.append(claimWrapper.getReason()).append(" ");
                }
                sb.append("(");
                sb.append(claimWrapper.getClaimedByName());
                sb.append(").");
                claim = sb.toString();
            } else {
                claim = NOT_CLAIMED;
            }
        }
        return claim;
    }

    @Override
    public String getUnclaimedMatrixBuilds() {
        if (Jenkins.getActiveInstance().getPlugin("claim") == null) {
            return "";
        }
        Run<?, ?> lastBuild = this.getLastCompletedRun();
        if (!(lastBuild instanceof MatrixBuild)) {
            return "";
        }
        MatrixBuild matrixBuild = (MatrixBuild)lastBuild;
        return this.buildMatrixClaimString(matrixBuild, false);
    }

    private Run<?, ?> getLastCompletedRun() {
        Run run;
        for (run = this.job.getLastBuild(); run != null && run.isBuilding(); run = run.getPreviousBuild()) {
        }
        return run;
    }

    private String buildMatrixClaimString(MatrixBuild matrixBuild, boolean includeClaimed) {
        StringBuilder claimed = new StringBuilder();
        StringBuilder unclaimed = new StringBuilder();
        for (MatrixRun combination : matrixBuild.getRuns()) {
            Result result;
            if (matrixBuild.getNumber() != combination.getNumber() || !Result.FAILURE.equals(result = combination.getResult()) && !Result.UNSTABLE.equals(result)) continue;
            ClaimWrapper claimWrapper = ClaimWrapper.builder(combination);
            if (claimWrapper != null && claimWrapper.isClaimed()) {
                claimed.append(combination.getParent().getCombination().toString());
                claimed.append(": ");
                if (claimWrapper.getReason() != null) {
                    claimed.append(claimWrapper.getReason()).append(" ");
                }
                claimed.append("(");
                claimed.append(claimWrapper.getClaimedByName());
                claimed.append(").<br/>");
                continue;
            }
            unclaimed.append(combination.getParent().getCombination().toString());
            unclaimed.append(": ").append(NOT_CLAIMED).append("<br/>");
        }
        String claims = unclaimed.toString();
        if (includeClaimed) {
            claims = claims + claimed.toString();
        }
        return claims;
    }

    @Override
    public boolean isClaimed() {
        return !NOT_CLAIMED.equals(this.getClaim());
    }

    @Override
    public boolean isCompletelyClaimed() {
        String claim = this.getClaim();
        if (StringUtils.isEmpty((String)claim)) {
            return false;
        }
        if (NOT_CLAIMED.equals(this.getClaim())) {
            return false;
        }
        return !claim.contains(NOT_CLAIMED);
    }

    @Override
    public Result getLastFinishedResult() {
        return RadiatorUtil.getLastFinishedResult(this.job);
    }

    @Override
    public boolean hasChildren() {
        return false;
    }
}

