/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.sonar.api;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.QGException;

public class SonarHttpRequester {
    private static final String SONAR_API_GATE = "/api/events?resource=%s&format=json&categories=Alert";
    private HttpClientContext context;

    public String getAPIInfo(JobConfigData projectKey, GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) throws QGException {
        String sonarApiGate = globalConfigDataForSonarInstance.getSonarUrl() + String.format(SONAR_API_GATE, projectKey.getProjectKey());
        this.context = HttpClientContext.create();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost loginHttpPost = new HttpPost(globalConfigDataForSonarInstance.getSonarUrl() + "/sessions/login");
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        nvps.add((NameValuePair)new BasicNameValuePair("login", globalConfigDataForSonarInstance.getUsername()));
        nvps.add((NameValuePair)new BasicNameValuePair("password", globalConfigDataForSonarInstance.getPass()));
        nvps.add((NameValuePair)new BasicNameValuePair("remember_me", "1"));
        loginHttpPost.setEntity((HttpEntity)this.createEntity(nvps));
        loginHttpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
        this.executePostRequest(client, loginHttpPost);
        HttpGet request = new HttpGet(String.format(sonarApiGate, projectKey.getProjectKey()));
        return this.executeGetRequest(client, request);
    }

    private String executeGetRequest(CloseableHttpClient client, HttpGet request) throws QGException {
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)request, (HttpContext)this.context);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String returnResponse = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
            if (statusCode != 200) {
                throw new QGException("Expected status 200, got: " + statusCode + ". Response: " + returnResponse);
            }
            String string = returnResponse;
            return string;
        }
        catch (IOException e) {
            throw new QGException("GET execution error", e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void executePostRequest(CloseableHttpClient client, HttpPost loginHttpPost) throws QGException {
        try {
            client.execute((HttpUriRequest)loginHttpPost);
        }
        catch (IOException e) {
            throw new QGException("POST execution error", e);
        }
    }

    private UrlEncodedFormEntity createEntity(List<NameValuePair> nvps) throws QGException {
        try {
            return new UrlEncodedFormEntity(nvps);
        }
        catch (UnsupportedEncodingException e) {
            throw new QGException("Encoding error", e);
        }
    }
}

