/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import javax.inject.Inject;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.JobConfigurationService;
import quality.gates.jenkins.plugin.JobExecutionService;
import quality.gates.jenkins.plugin.QGException;
import quality.gates.jenkins.plugin.QGPublisher;

@Extension
public final class QGPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    @Inject
    private JobConfigurationService jobConfigurationService;
    @Inject
    private JobExecutionService jobExecutionService;

    public QGPublisherDescriptor() {
        super(QGPublisher.class);
        this.load();
    }

    public QGPublisherDescriptor(JobExecutionService jobExecutionService, JobConfigurationService jobConfigurationService) {
        super(QGPublisher.class);
        this.jobExecutionService = jobExecutionService;
        this.jobConfigurationService = jobConfigurationService;
    }

    public JobExecutionService getJobExecutionService() {
        return this.jobExecutionService;
    }

    public ListBoxModel doFillListOfGlobalConfigDataItems() {
        return this.jobConfigurationService.getListOfSonarInstanceNames(this.jobExecutionService.getGlobalConfigData());
    }

    public FormValidation doCheckProjectKey(@QueryParameter String projectKey) {
        if (projectKey.isEmpty()) {
            return FormValidation.error((String)"Please insert project key.");
        }
        return FormValidation.ok();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDisplayName() {
        return "Quality Gates";
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        this.save();
        return true;
    }

    public QGPublisher newInstance(StaplerRequest req, JSONObject formData) throws QGException {
        JobConfigData firstInstanceJobConfigData = this.jobConfigurationService.createJobConfigData(formData, this.jobExecutionService.getGlobalConfigData());
        return new QGPublisher(firstInstanceJobConfigData);
    }
}

