/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import org.kohsuke.stapler.DataBoundConstructor;
import quality.gates.jenkins.plugin.BuildDecision;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.JobConfigurationService;
import quality.gates.jenkins.plugin.JobExecutionService;
import quality.gates.jenkins.plugin.QGException;
import quality.gates.jenkins.plugin.QGPublisherDescriptor;

public class QGPublisher
extends Recorder {
    private JobConfigData jobConfigData;
    private BuildDecision buildDecision;
    private JobConfigurationService jobConfigurationService;
    private JobExecutionService jobExecutionService;
    private GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance;

    @DataBoundConstructor
    public QGPublisher(JobConfigData jobConfigData) {
        this.jobConfigData = jobConfigData;
        this.buildDecision = new BuildDecision();
        this.jobExecutionService = new JobExecutionService();
        this.jobConfigurationService = new JobConfigurationService();
        this.globalConfigDataForSonarInstance = null;
    }

    public QGPublisher(JobConfigData jobConfigData, BuildDecision buildDecision, JobExecutionService jobExecutionService, JobConfigurationService jobConfigurationService, GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) {
        this.jobConfigData = jobConfigData;
        this.buildDecision = buildDecision;
        this.jobConfigurationService = jobConfigurationService;
        this.jobExecutionService = jobExecutionService;
        this.globalConfigDataForSonarInstance = globalConfigDataForSonarInstance;
    }

    public JobConfigData getJobConfigData() {
        return this.jobConfigData;
    }

    public QGPublisherDescriptor getDescriptor() {
        return (QGPublisherDescriptor)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.globalConfigDataForSonarInstance = this.buildDecision.chooseSonarInstance(this.jobExecutionService.getGlobalConfigData(), this.jobConfigData);
        if (this.globalConfigDataForSonarInstance == null) {
            listener.error("The Sonar Instance in the global configuration with name '%s' no longer exists.\n", new Object[]{this.jobConfigData.getSonarInstanceName()});
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.getLogger());
        }
        Result result = build.getResult();
        if (Result.SUCCESS != result) {
            listener.getLogger().println("Previous steps failed the build.\nResult is: " + result);
            return false;
        }
        try {
            JobConfigData checkedJobConfigData = this.jobConfigurationService.checkProjectKeyIfVariable(this.jobConfigData, build, listener);
            boolean buildPassed = this.buildDecision.getStatus(this.globalConfigDataForSonarInstance, checkedJobConfigData);
            if ("".equals(this.jobConfigData.getSonarInstanceName())) {
                listener.getLogger().println("WARNING: Quality Gates is running with default Sonar Instance.\nURL='http//localhost:9000'\nUsername='admin'\nPassword='admin'");
            }
            listener.getLogger().println("PostBuild-Step: Quality Gates plugin build passed: " + String.valueOf(buildPassed).toUpperCase());
            return buildPassed;
        }
        catch (QGException e) {
            e.printStackTrace(listener.getLogger());
            return false;
        }
    }
}

