/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.tasks.Builder;
import org.kohsuke.stapler.DataBoundConstructor;
import quality.gates.jenkins.plugin.BuildDecision;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.JobConfigurationService;
import quality.gates.jenkins.plugin.JobExecutionService;
import quality.gates.jenkins.plugin.QGBuilderDescriptor;
import quality.gates.jenkins.plugin.QGException;

public class QGBuilder
extends Builder {
    private JobConfigData jobConfigData;
    private BuildDecision buildDecision;
    private JobConfigurationService jobConfigurationService;
    private JobExecutionService jobExecutionService;
    private GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance;

    @DataBoundConstructor
    public QGBuilder(JobConfigData jobConfigData) {
        this.jobConfigData = jobConfigData;
        this.buildDecision = new BuildDecision();
        this.jobExecutionService = new JobExecutionService();
        this.jobConfigurationService = new JobConfigurationService();
        this.globalConfigDataForSonarInstance = null;
    }

    protected QGBuilder(JobConfigData jobConfigData, BuildDecision buildDecision, JobExecutionService jobExecutionService, JobConfigurationService jobConfigurationService, GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance) {
        this.jobConfigData = jobConfigData;
        this.buildDecision = buildDecision;
        this.jobExecutionService = jobExecutionService;
        this.jobConfigurationService = jobConfigurationService;
        this.globalConfigDataForSonarInstance = globalConfigDataForSonarInstance;
    }

    public JobConfigData getJobConfigData() {
        return this.jobConfigData;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.globalConfigDataForSonarInstance = this.buildDecision.chooseSonarInstance(this.jobExecutionService.getGlobalConfigData(), this.jobConfigData);
        if (this.globalConfigDataForSonarInstance == null) {
            listener.error("The Sonar Instance in the global configuration with name '%s' no longer exists.\n", new Object[]{this.jobConfigData.getSonarInstanceName()});
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.getLogger());
        }
        try {
            JobConfigData checkedJobConfigData = this.jobConfigurationService.checkProjectKeyIfVariable(this.jobConfigData, build, listener);
            boolean buildHasPassed = this.buildDecision.getStatus(this.globalConfigDataForSonarInstance, checkedJobConfigData);
            if ("".equals(this.jobConfigData.getSonarInstanceName())) {
                listener.getLogger().println("WARNING: Quality Gates is running with default Sonar Instance.\nURL='http//localhost:9000'\nUsername='admin'\nPassword='admin'");
            }
            listener.getLogger().println("Build-Step: Quality Gates plugin build passed: " + String.valueOf(buildHasPassed).toUpperCase());
            return buildHasPassed;
        }
        catch (QGException e) {
            e.printStackTrace(listener.getLogger());
            return false;
        }
    }

    public QGBuilderDescriptor getDescriptor() {
        return (QGBuilderDescriptor)super.getDescriptor();
    }
}

