/*
 * Decompiled with CFR 0.152.
 */
package quality.gates.jenkins.plugin;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import net.sf.json.JSONObject;
import quality.gates.jenkins.plugin.GlobalConfig;
import quality.gates.jenkins.plugin.GlobalConfigDataForSonarInstance;
import quality.gates.jenkins.plugin.JobConfigData;
import quality.gates.jenkins.plugin.QGException;

public class JobConfigurationService {
    public ListBoxModel getListOfSonarInstanceNames(GlobalConfig globalConfig) {
        ListBoxModel listBoxModel = new ListBoxModel();
        for (GlobalConfigDataForSonarInstance globalConfigDataForSonarInstance : globalConfig.fetchListOfGlobalConfigData()) {
            listBoxModel.add(globalConfigDataForSonarInstance.getName());
        }
        return listBoxModel;
    }

    public JobConfigData createJobConfigData(JSONObject formData, GlobalConfig globalConfig) {
        JobConfigData firstInstanceJobConfigData = new JobConfigData();
        String projectKey = formData.getString("projectKey");
        if (projectKey.startsWith("$")) {
            String systemVariableName = projectKey;
            String getEnvVariable = systemVariableName.substring(2, systemVariableName.length() - 1);
            if ((projectKey = System.getenv(getEnvVariable)) == null) {
                throw new QGException("Environment variable with name '" + getEnvVariable + "' does not exist.");
            }
        } else {
            try {
                projectKey = URLDecoder.decode(projectKey, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new QGException("Error while decoding the project key. UTF-8 not supported.", e);
            }
        }
        String name = !globalConfig.fetchListOfGlobalConfigData().isEmpty() ? this.hasFormDataKey(formData, globalConfig) : "";
        firstInstanceJobConfigData.setProjectKey(projectKey);
        firstInstanceJobConfigData.setSonarInstanceName(name);
        return firstInstanceJobConfigData;
    }

    protected String hasFormDataKey(JSONObject formData, GlobalConfig globalConfig) {
        String instanceName = formData.containsKey((Object)"sonarInstancesName") ? formData.getString("sonarInstancesName") : globalConfig.fetchListOfGlobalConfigData().get(0).getName();
        return instanceName;
    }

    public JobConfigData checkProjectKeyIfVariable(JobConfigData jobConfigData, AbstractBuild build, BuildListener listener) throws QGException {
        JobConfigData envVariableJobConfigData = new JobConfigData();
        envVariableJobConfigData.setProjectKey(jobConfigData.getProjectKey());
        envVariableJobConfigData.setSonarInstanceName(jobConfigData.getSonarInstanceName());
        if (jobConfigData.getProjectKey().isEmpty()) {
            throw new QGException("Empty project key.");
        }
        if (jobConfigData.getProjectKey().startsWith("$")) {
            String stripProjectKey = jobConfigData.getProjectKey().substring(1);
            if (stripProjectKey.startsWith("{") && stripProjectKey.endsWith("}")) {
                stripProjectKey = stripProjectKey.substring(1, stripProjectKey.length() - 1);
            }
            try {
                String getEnvVariable = (String)build.getEnvironment((TaskListener)listener).get((Object)stripProjectKey);
                if (getEnvVariable == null) {
                    throw new QGException("Environment variable with name '" + stripProjectKey + "' was not found.");
                }
                envVariableJobConfigData.setProjectKey(getEnvVariable);
            }
            catch (IOException e) {
                throw new QGException(e);
            }
            catch (InterruptedException e) {
                throw new QGException(e);
            }
        }
        return envVariableJobConfigData;
    }
}

